<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeePayrollCfdisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_payroll_cfdis', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('employee_payroll_id');
            $table->string('name',100);
            $table->unsignedInteger('pac_id')->nullable();
            $table->string('cfdi_version',100)->nullable();
            $table->string('uuid')->nullable();
            $table->dateTime('date')->nullable();
            $table->string('file_xml')->nullable();
            $table->string('file_xml_pac')->nullable();
            $table->dateTime('cancel_date')->nullable();
            $table->text('cancel_response')->nullable();
            $table->string('cancel_state')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('employee_payroll_id')->references('id')->on('employee_payrolls')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('pac_id')->references('id')->on('pacs')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_payroll_cfdis');
    }
}
