<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEmployeePayrollRelationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_payroll_relations', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('employee_payroll_id');
            $table->unsignedInteger('relation_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);
            $table->string('uuid_related')->nullable();

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('employee_payroll_id')->references('id')->on('employee_payrolls')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('relation_id')->references('id')->on('employee_payrolls')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_payroll_relations');
    }
}
