<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',200);
            $table->string('generated_type',100);
            $table->string('file',100);
            $table->unsignedInteger('payroll_type_id')->nullable();
            $table->unsignedInteger('branch_office_id')->nullable();
            $table->date('date_payment')->nullable();
            $table->date('date_start_payment')->nullable();
            $table->date('date_end_payment')->nullable();
            $table->integer('payment_days')->default(0);
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_isr',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->decimal('amount_perceptions',15,5)->default(0);
            $table->decimal('amount_deductions',15,5)->default(0);
            $table->decimal('amount_other_payment_types',15,5)->default(0);
            $table->text('comment')->nullable();
            $table->boolean('mail_sent')->default(FALSE);
            $table->unsignedInteger('company_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->tinyInteger('status')->default(\App\Models\Base\Payroll::OPEN);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('payroll_type_id')->references('id')->on('payroll_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('branch_office_id')->references('id')->on('branch_offices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
}
