<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAccionsHoursToEmployeePayrollLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_payroll_lines', function (Blueprint $table) {
            $table->decimal('ac_market_value',15,5)->default(0);
            $table->decimal('ac_price_when_granted',15,5)->default(0);
            $table->integer('hr_days_1')->default(0);
            $table->unsignedInteger('hr_overtimes_type_id_1')->nullable();
            $table->integer('hr_hours_1')->default(0);
            $table->decimal('hr_amount_paid_1',15,5)->default(0);
            $table->integer('hr_days_2')->default(0);
            $table->unsignedInteger('hr_overtimes_type_id_2')->nullable();
            $table->integer('hr_hours_2')->default(0);
            $table->decimal('hr_amount_paid_2',15,5)->default(0);
            $table->integer('hr_days_3')->default(0);
            $table->unsignedInteger('hr_overtimes_type_id_3')->nullable();
            $table->integer('hr_hours_3')->default(0);
            $table->decimal('hr_amount_paid_3',15,5)->default(0);

            // Foreign
            $table->foreign('hr_overtimes_type_id_1')->references('id')->on('overtimes_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('hr_overtimes_type_id_2')->references('id')->on('overtimes_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('hr_overtimes_type_id_3')->references('id')->on('overtimes_types')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_payroll_lines', function (Blueprint $table) {
            $table->dropColumn('ac_market_value');
            $table->dropColumn('ac_price_when_granted');
            $table->dropColumn('hr_days_1');
            $table->dropForeign(['hr_overtimes_type_id_1']);
            $table->dropColumn('hr_overtimes_type_id_1');
            $table->dropColumn('hr_hours_1');
            $table->dropColumn('hr_amount_paid_1');
            $table->dropColumn('hr_days_2');
            $table->dropForeign(['hr_overtimes_type_id_2']);
            $table->dropColumn('hr_overtimes_type_id_2');
            $table->dropColumn('hr_hours_2');
            $table->dropColumn('hr_amount_paid_2');
            $table->dropColumn('hr_days_3');
            $table->dropForeign(['hr_overtimes_type_id_3']);
            $table->dropColumn('hr_overtimes_type_id_3');
            $table->dropColumn('hr_hours_3');
            $table->dropColumn('hr_amount_paid_3');
        });
    }
}
