<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCompensationToEmployeePayrollLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_payroll_lines', function (Blueprint $table) {
            $table->decimal('cm_positive_balance',15,5)->default(0);
            $table->integer('cm_year')->default(0);
            $table->decimal('cm_remainder',15,5)->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_payroll_lines', function (Blueprint $table) {
            $table->dropColumn('cm_positive_balance');
            $table->dropColumn('cm_year');
            $table->dropColumn('cm_remainder');
        });
    }
}
