<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDisabilitiesToEmployeePayrollLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_payroll_lines', function (Blueprint $table) {
            $table->unsignedInteger('disability_type_id')->nullable();
            $table->integer('disability_days')->default(0);
            $table->decimal('disability_amount',15,5)->default(0);

            // Foreign
            $table->foreign('disability_type_id')->references('id')->on('disability_types')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_payroll_lines', function (Blueprint $table) {
            $table->dropForeign(['disability_type_id']);
            $table->dropColumn('disability_type_id');
            $table->dropColumn('disability_days');
            $table->dropColumn('disability_amount');
        });
    }
}
