<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPaymentPlatformToFolios extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('folios', function (Blueprint $table) {
            $table->string('payment_platform')->nullable();
            $table->text('payment_platform_request')->nullable();
            $table->text('payment_platform_response')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('folios', function (Blueprint $table) {
            $table->dropColumn('payment_platform');
            $table->dropColumn('payment_platform_request');
            $table->dropColumn('payment_platform_response');
        });
    }
}
