<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCfdiDownloadsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cfdi_downloads', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->integer('type')->nullable(); //1 recibidos, 2 emitidos
            $table->string('uuid',50)->nullable();
            $table->string('name',100)->nullable();
            $table->string('serie',64)->nullable();
            $table->string('folio',64)->nullable();
            $table->dateTime('date')->nullable();
            $table->dateTime('date_certification')->nullable();
            $table->string('rfc_emisor',100)->nullable();
            $table->string('emisor')->nullable();
            $table->string('rfc_receptor',100)->nullable();
            $table->string('receptor')->nullable();
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('payment_method_id')->nullable();
            $table->unsignedInteger('cfdi_use_id')->nullable();
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->unsignedInteger('cfdi_type_id')->nullable();
            $table->string('status',64)->nullable();
            $table->string('is_cancelable',64)->nullable();
            $table->string('cancel_status',64)->nullable();
            $table->string('rfc_pac',100)->nullable();
            $table->string('file_xml')->nullable();
            $table->string('file_pdf')->nullable();
            $table->string('file_acuse')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->text('comment')->nullable();

            // Index
            $table->index('id','id','BTREE');
            $table->index('uuid','uuid','BTREE');

            // Foreign
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_method_id')->references('id')->on('payment_methods')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_use_id')->references('id')->on('cfdi_uses')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_type_id')->references('id')->on('cfdi_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cfdi_downloads');
    }
}
