<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDateExpenseToCfdiDownloads extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cfdi_downloads', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('expense_type_id')->nullable();
            $table->date('date_payment')->nullable();

            // Foreign
            $table->foreign('expense_type_id')->references('id')->on('expense_types')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cfdi_downloads', function (Blueprint $table) {
            $table->dropForeign(['expense_type_id']);
            $table->dropColumn('expense_type_id');
            $table->dropColumn('date_payment');
        });
    }
}
