<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecurringCustomerInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recurring_customer_invoices', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->string('name',50)->nullable();
            $table->date('date_start')->nullable();
            $table->date('date_end')->nullable();
            $table->date('date_last')->nullable();
            $table->date('date_next')->nullable();
            $table->string('frequency',32)->nullable();
            $table->boolean('mail_sent')->default(FALSE);
            $table->string('reference',100)->nullable();
            $table->unsignedInteger('customer_id')->nullable();
            $table->unsignedInteger('branch_office_id')->nullable();
            $table->unsignedInteger('payment_term_id')->nullable();
            $table->unsignedInteger('payment_way_id')->nullable();
            $table->unsignedInteger('payment_method_id')->nullable();
            $table->unsignedInteger('cfdi_use_id')->nullable();
            $table->unsignedInteger('salesperson_id')->nullable();
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->text('comment')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);
            $table->string('confirmacion')->nullable();
            $table->date('date_delivery')->nullable();
            $table->string('source')->nullable();
            $table->text('source_name')->nullable();
            $table->text('source_taxid')->nullable();
            $table->text('source_address')->nullable();
            $table->text('source_delivery_on')->nullable();
            $table->string('destination')->nullable();
            $table->string('destination_name')->nullable();
            $table->string('destination_taxid')->nullable();
            $table->text('destination_address')->nullable();
            $table->text('destination_delivery_on')->nullable();
            $table->decimal('valid_amount',15,5)->default(0);
            $table->boolean('dangerous_material')->default(FALSE);
            $table->string('compensation')->nullable();
            $table->string('retainer_name')->nullable();
            $table->string('retainer_taxid')->nullable();
            $table->string('driver')->nullable();
            $table->string('vehicle')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->string('vehicle_counter')->nullable();
            $table->string('cfdi_type2')->nullable(); //invoice, transfer, lease, fee, credit_note, payment
            $table->string('document_type2')->nullable(); //invoice, transfer
            //descripcion de mercancias
            //peso
            //metroscubicos
            //litros
            //Hoja de politicas
            $table->unsignedInteger('company_id')->nullable();
            $table->unsignedInteger('transfer_reason_id')->nullable();
            $table->unsignedInteger('operation_type_id')->nullable();
            $table->unsignedInteger('pediment_id')->nullable();
            $table->string('origin_certificate')->nullable();
            $table->string('number_origin_certificate')->nullable();
            $table->string('reliable_exporter_number')->nullable();
            $table->unsignedInteger('incoterm_id')->nullable();
            $table->string('subdivision')->nullable();
            $table->text('comment_foreign_trade')->nullable();
            $table->decimal('exchange_rate_usd',15,8)->default(0);
            $table->decimal('amount_total_usd',15,5)->default(0);
            $table->string('title')->nullable();
            $table->unsignedInteger('project_id')->nullable();
            $table->dateTime('date_process')->nullable();
            $table->text('status_process')->nullable();

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('customer_id')->references('id')->on('customers')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('branch_office_id')->references('id')->on('branch_offices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_term_id')->references('id')->on('payment_terms')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('payment_method_id')->references('id')->on('payment_methods')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_use_id')->references('id')->on('cfdi_uses')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('salesperson_id')->references('id')->on('salespersons')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('transfer_reason_id')->references('id')->on('transfer_reasons')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('operation_type_id')->references('id')->on('operation_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('pediment_id')->references('id')->on('pediments')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('incoterm_id')->references('id')->on('incoterms')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('project_id')->references('id')->on('projects')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recurring_customer_invoices');
    }
}
