<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecurringCustomerInvoiceLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recurring_customer_invoice_lines', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('recurring_customer_invoice_id');
            $table->text('name');
            $table->unsignedInteger('product_id')->nullable();
            $table->unsignedInteger('sat_product_id')->nullable();
            $table->unsignedInteger('unit_measure_id')->nullable();
            $table->decimal('quantity',15,5)->default(0);
            $table->decimal('price_unit',15,5)->default(0);
            $table->decimal('discount',15,3)->default(0);
            $table->decimal('price_reduce',15,5)->default(0);
            $table->decimal('amount_discount',15,5)->default(0);
            $table->decimal('amount_untaxed',15,5)->default(0);
            $table->decimal('amount_tax',15,5)->default(0);
            $table->decimal('amount_tax_ret',15,5)->default(0);
            $table->decimal('amount_total',15,5)->default(0);
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('recurring_customer_invoice_id','rec_cil_recurring_customer_invoice_id_foreign')->references('id')->on('recurring_customer_invoices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('product_id')->references('id')->on('products')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('sat_product_id')->references('id')->on('sat_products')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('unit_measure_id')->references('id')->on('unit_measures')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recurring_customer_invoice_lines');
    }
}
