<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecurringCustomerInvoiceLineTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recurring_customer_invoice_line_taxes', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('recurring_customer_invoice_line_id');
            $table->unsignedInteger('tax_id');

            // Index
            $table->index('recurring_customer_invoice_line_id','recurring_customer_invoice_line_id','BTREE');
            $table->index('tax_id','tax_id','BTREE');

            // Llave primaria
            $table->primary(['recurring_customer_invoice_line_id','tax_id'],'rec_cil_customer_invoice_line_id_tax_id_pk');

            // Foreign
            $table->foreign('recurring_customer_invoice_line_id','rec_cilt_recurring_customer_invoice_line_id_foreign')->references('id')->on('recurring_customer_invoice_lines')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recurring_customer_invoice_line_taxes');
    }
}
