<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecurringCustomerInvoiceLineComplementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recurring_customer_invoice_line_complements', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('recurring_customer_invoice_line_id')->nullable();
            $table->text('name')->nullable();
            $table->unsignedInteger('customer_iedu_id')->nullable();
            $table->string('iedu_nombre_alumno')->nullable();
            $table->string('iedu_curp')->nullable();
            $table->string('iedu_nivel_educativo')->nullable();
            $table->string('iedu_aut_rvoe')->nullable();
            $table->string('iedu_rfc_pago')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);
            $table->text('numero_predial')->nullable();
            $table->unsignedInteger('tariff_fraction_id')->nullable();
            $table->decimal('customs_quantity',15,5)->default(0);
            $table->unsignedInteger('uom_custom_id')->nullable();
            $table->decimal('price_unit_usd',15,5)->default(0);
            $table->decimal('amount_usd',15,5)->default(0);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('recurring_customer_invoice_line_id','rec_cilc_customer_invoice_line_id_fk')->references('id')->on('recurring_customer_invoice_lines')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('customer_iedu_id','rec_cilc_customer_iedu_id_fk')->references('id')->on('customer_iedus')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tariff_fraction_id','rec_cilc_tariff_fraction_id_fk')->references('id')->on('tariff_fractions')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('uom_custom_id','rec_cilc_uom_customer_id_fk')->references('id')->on('uom_customs')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recurring_customer_invoice_line_complements');
    }
}
