<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecurringCustomerInvoiceLineTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recurring_customer_invoice_line_transfers', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('recurring_customer_invoice_id');
            $table->text('name');
            $table->unsignedInteger('product_id')->nullable();
            $table->string('weight')->nullable();
            $table->decimal('m3',15,5)->default(0);
            $table->decimal('liters',15,3)->default(0);
            $table->string('packaging')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('recurring_customer_invoice_id','rec_ciltr_recurring_customer_invoice_line_id_foreign')->references('id')->on('recurring_customer_invoices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('product_id','rec_ciltr_producct_id_foreign')->references('id')->on('products')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recurring_customer_invoice_line_transfers');
    }
}
