<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCfdiDownloadPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cfdi_download_payments', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedBigInteger('cfdi_download_id');
            $table->unsignedInteger('currency_id')->nullable();
            $table->decimal('currency_value',15,8)->default(0)->nullable();
            $table->date('date_payment')->nullable();
            $table->decimal('amount_payment',15,5)->default(0);
            $table->string('reference')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('cfdi_download_id')->references('id')->on('cfdi_downloads')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cfdi_download_payments');
    }
}
