<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPaymentWayIdToCfdiDownloadPayments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cfdi_download_payments', function (Blueprint $table) {
            //Campos
            $table->unsignedInteger('payment_way_id')->nullable();

            // Foreign
            $table->foreign('payment_way_id')->references('id')->on('payment_ways')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cfdi_download_payments', function (Blueprint $table) {
            $table->dropForeign(['payment_way_id']);
            $table->dropColumn('payment_way_id');
        });
    }
}
