<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOperationalTypeComment2ToCfdiDownloads extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cfdi_downloads', function (Blueprint $table) {
            //Campos
            $table->unsignedInteger('operational_type_id')->nullable();
            $table->text('comment_2')->nullable();

            // Foreign
            $table->foreign('operational_type_id')->references('id')->on('operational_types')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cfdi_downloads', function (Blueprint $table) {
            $table->dropForeign(['operational_type_id']);
            $table->dropColumn('operational_type_id');
            $table->dropColumn('comment_2');
        });
    }
}
