<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBankMovesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_moves', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->text('key')->nullable();
            $table->dateTime('date')->nullable();
            $table->string('reference')->nullable();
            $table->decimal('amount',15,5)->default(0);
            $table->unsignedInteger('currency_id')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->string('file_template')->nullable();
            $table->unsignedInteger('bank_reconciliation_line_id')->nullable();
            $table->boolean('status')->default(TRUE);

            //Index
            $table->index('id','id','BTREE');

            //Foreign
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('bank_reconciliation_line_id')->references('id')->on('bank_reconciliation_lines')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_moves');
    }
}
