<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBankMoveReconciledsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_move_reconcileds', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('bank_move_id')->nullable();
            $table->unsignedBigInteger('reconciled_id')->nullable();
            $table->text('key')->nullable();
            $table->decimal('amount_reconciled',15,5)->default(0);
            $table->unsignedInteger('bank_reconciliation_line_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('bank_move_id')->references('id')->on('bank_moves')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('reconciled_id')->references('id')->on('cfdi_downloads')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('bank_reconciliation_line_id','b_m_t_r_bank_reconciliation_line_id_foreign')->references('id')->on('bank_reconciliation_lines')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_move_reconcileds');
    }
}
