<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBankReconciliationUnreconcilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_reconciliation_unreconciles', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->unsignedInteger('bank_reconciliation_id')->nullable();
            $table->unsignedBigInteger('cfdi_download_id')->nullable();
            $table->text('key')->nullable();
            $table->integer('sort_order')->nullable();
            $table->boolean('status')->default(TRUE);

            //Index
            $table->index('id','id','BTREE');

            //Foreign
            $table->foreign('bank_reconciliation_id')->references('id')->on('bank_reconciliations')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_download_id')->references('id')->on('cfdi_downloads')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_reconciliation_unreconciles');
    }
}
