<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFielToCompanies extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->string('fiel_file_cer')->nullable();
            $table->string('fiel_file_key')->nullable();
            $table->text('fiel_password_key')->nullable();
            $table->string('fiel_file_pfx')->nullable();
            $table->string('fiel_certificate_number',64)->nullable();
            $table->dateTime('fiel_date_start')->nullable();
            $table->dateTime('fiel_date_end')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn('fiel_file_cer');
            $table->dropColumn('fiel_file_key');
            $table->dropColumn('fiel_password_key');
            $table->dropColumn('fiel_file_pfx');
            $table->dropColumn('fiel_certificate_number');
            $table->dropColumn('fiel_date_start');
            $table->dropColumn('fiel_date_end');
        });
    }
}
