<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCfdiDownloadRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cfdi_download_requests', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->dateTime('date')->nullable();
            $table->string('folio')->nullable();
            $table->string('folio_metadata')->nullable();
            $table->integer('type')->nullable(); //1 recibidos, 2 emitidos
            $table->dateTime('date_start')->nullable();
            $table->dateTime('date_end')->nullable();
            $table->integer('qty')->nullable();
            $table->string('folio_download')->nullable();
            $table->string('folio_download_metadata')->nullable();
            $table->string('file')->nullable();
            $table->string('file_metadata')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->integer('completed')->default(0);
            $table->integer('status')->default(1);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cfdi_download_requests');
    }
}
