<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDiotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('diots', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->string('name')->nullable();
            $table->dateTime('date')->nullable();
            $table->integer('month')->nullable();
            $table->integer('year')->nullable();
            $table->string('file')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->boolean('status')->default(TRUE);


            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('company_id')->references('id')->on('companies')->onUpdate('cascade')->onDelete('restrict');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('diots');
    }
}
