<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDiotLinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('diot_lines', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->unsignedBigInteger('diot_id');
            $table->unsignedBigInteger('cfdi_download_id');
            $table->string('customer_type')->nullable();
            $table->string('operation_type')->nullable();
            $table->string('taxid')->nullable();
            $table->string('numid')->nullable();
            $table->string('name')->nullable();
            $table->string('foreign_country_code')->nullable();
            $table->string('foreign_nationality')->nullable();
            $table->string('iva_15_16')->nullable();
            $table->string('iva_15')->nullable();
            $table->string('iva_15_16_not')->nullable();
            $table->string('iva_10_11')->nullable();
            $table->string('iva_10')->nullable();
            $table->string('border_stimulation')->nullable();
            $table->string('iva_10_11_not')->nullable();
            $table->string('border_stimulation_not')->nullable();
            $table->string('foreign_iva_15_16')->nullable();
            $table->string('foreign_iva_15_16_not')->nullable();
            $table->string('foreign_iva_10_11')->nullable();
            $table->string('foreign_iva_10_11_not')->nullable();
            $table->string('foreign_exempt')->nullable();
            $table->string('iva_0')->nullable();
            $table->string('exempt')->nullable();
            $table->string('iva_detained')->nullable();
            $table->string('iva_dev_dis_bon')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('diot_id')->references('id')->on('diots')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('cfdi_download_id')->references('id')->on('cfdi_downloads')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('diot_lines');
    }
}
