<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddQuotaIepsDecimalPlacesToProducts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('price',15,6)->default(0)->change();
            $table->decimal('quota_ieps',15,6)->default(0);
            $table->integer('price_decimal_place')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->decimal('price',15,5)->default(0)->change();
            $table->dropColumn('quota_ieps');
            $table->dropColumn('price_decimal_place');
        });
    }
}
