<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeDecimalPlacesToCustomerQuotationLines extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_quotation_lines', function (Blueprint $table) {
            $table->decimal('price_unit',15,6)->default(0)->change();
            $table->decimal('price_reduce',15,6)->default(0)->change();
            $table->decimal('quota_ieps',15,6)->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_quotation_lines', function (Blueprint $table) {
            $table->decimal('price_unit',15,5)->default(0)->change();
            $table->decimal('price_reduce',15,5)->default(0)->change();
            $table->dropColumn('quota_ieps');
        });
    }
}
