<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSncfToEmployeePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_payrolls', function (Blueprint $table) {
            $table->unsignedInteger('source_resource_id')->nullable();
            $table->decimal('sncf_amount_source_resource',15,5)->default(0);

            // Foreign
            $table->foreign('source_resource_id')->references('id')->on('source_resources')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_payrolls', function (Blueprint $table) {
            $table->dropForeign(['source_resource_id']);
            $table->dropColumn('source_resource_id');
            $table->dropColumn('sncf_amount_source_resource');
        });
    }
}
