<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stations', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->string('name')->nullable();
            $table->string('code')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);
            $table->unsignedInteger('transport_type_id')->nullable();
            $table->string('nationality')->nullable();
            $table->string('designator')->nullable();
            $table->string('railway_line')->nullable();

            //Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');

            //
            $table->foreign('transport_type_id')->references('id')->on('transport_types')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stations');
    }
}
