<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InsertCartaPorte extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        \App\Models\Catalogs\AuthorizationAgent::truncate();
        \App\Models\Catalogs\CarType::truncate();
        \App\Models\Catalogs\ContainerMaritime::truncate();
        \App\Models\Catalogs\ContainerType::truncate();
        \App\Models\Catalogs\DangerousProduct::truncate();
        \App\Models\Catalogs\LoadType::truncate();
        \App\Models\Catalogs\MeasurePackaging::truncate();
        \App\Models\Catalogs\PackagingType::truncate();
        \App\Models\Catalogs\PermitType::truncate();
        \App\Models\Catalogs\RightsWay::truncate();
        \App\Models\Catalogs\SatProductStcc::truncate();
        \App\Models\Catalogs\ServiceType::truncate();
        \App\Models\Catalogs\SettingMaritime::truncate();
        \App\Models\Catalogs\SettingTransport::truncate();
        \App\Models\Catalogs\Station::truncate();
        \App\Models\Catalogs\StationType::truncate();
        \App\Models\Catalogs\TrailerType::truncate();
        \App\Models\Catalogs\TransportAerial::truncate();
        \App\Models\Catalogs\TransportFigure::truncate();
        \App\Models\Catalogs\TransportPart::truncate();
        \App\Models\Catalogs\TransportType::truncate();
        \App\Models\Catalogs\TrafficType::truncate();

        Schema::enableForeignKeyConstraints();

        $sql_carta_porte = \Storage::path('sql/carta_porte.sql');
        \DB::unprepared(file_get_contents($sql_carta_porte));
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();

        \App\Models\Catalogs\AuthorizationAgent::truncate();
        \App\Models\Catalogs\CarType::truncate();
        \App\Models\Catalogs\ContainerMaritime::truncate();
        \App\Models\Catalogs\ContainerType::truncate();
        \App\Models\Catalogs\DangerousProduct::truncate();
        \App\Models\Catalogs\LoadType::truncate();
        \App\Models\Catalogs\MeasurePackaging::truncate();
        \App\Models\Catalogs\PackagingType::truncate();
        \App\Models\Catalogs\PermitType::truncate();
        \App\Models\Catalogs\RightsWay::truncate();
        \App\Models\Catalogs\SatProductStcc::truncate();
        \App\Models\Catalogs\ServiceType::truncate();
        \App\Models\Catalogs\SettingMaritime::truncate();
        \App\Models\Catalogs\SettingTransport::truncate();
        \App\Models\Catalogs\Station::truncate();
        \App\Models\Catalogs\StationType::truncate();
        \App\Models\Catalogs\TrailerType::truncate();
        \App\Models\Catalogs\TransportAerial::truncate();
        \App\Models\Catalogs\TransportFigure::truncate();
        \App\Models\Catalogs\TransportPart::truncate();
        \App\Models\Catalogs\TransportType::truncate();
        \App\Models\Catalogs\TrafficType::truncate();

        Schema::enableForeignKeyConstraints();
    }
}
