<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerInvoiceTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_invoice_transfers', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('customer_invoice_id')->nullable();
            $table->string('transport_int')->nullable();
            $table->string('distance_traveled')->nullable();
            $table->string('in_out_product')->nullable();
            $table->unsignedInteger('in_out_country_id')->nullable(); //Pais
            $table->unsignedInteger('transport_type_id')->nullable();
            $table->unsignedInteger('trans_transport_type_id')->nullable();
            $table->unsignedInteger('source_station_type_id')->nullable();
            $table->string('source_distance_traveled')->nullable();
            $table->string('source_id')->nullable();
            $table->string('source_taxid')->nullable();
            $table->string('source_name')->nullable();
            $table->unsignedInteger('source_tr_country_id')->nullable(); //Pais
            $table->string('source_numid')->nullable();
            $table->unsignedInteger('source_station_id')->nullable();
            $table->string('source_station')->nullable();
            $table->string('source_traffic_navigation')->nullable();
            $table->dateTime('source_date')->nullable();
            $table->string('source_address_1',100)->nullable(); //Direccion
            $table->string('source_address_2',50)->nullable(); //Num. Ext
            $table->string('source_address_3',50)->nullable(); //Num Int.
            $table->string('source_address_4',100)->nullable(); //Colonia
            $table->string('source_address_5',100)->nullable(); //Localidad
            $table->string('source_address_6',150)->nullable(); //Referencia
            $table->unsignedInteger('source_city_id')->nullable(); //Municipio
            $table->unsignedInteger('source_state_id')->nullable(); //Estado
            $table->unsignedInteger('source_country_id')->nullable(); //Pais
            $table->string('source_postcode',10)->nullable(); //CP
            $table->unsignedInteger('destination_station_type_id')->nullable();
            $table->string('destination_distance_traveled')->nullable();
            $table->string('destination_id')->nullable();
            $table->string('destination_taxid')->nullable();
            $table->string('destination_name')->nullable();
            $table->unsignedInteger('destination_tr_country_id')->nullable(); //Pais
            $table->string('destination_numid')->nullable();
            $table->unsignedInteger('destination_station_id')->nullable();
            $table->string('destination_station')->nullable();
            $table->string('destination_traffic_navigation')->nullable();
            $table->dateTime('destination_date')->nullable();
            $table->string('destination_address_1',100)->nullable(); //Direccion
            $table->string('destination_address_2',50)->nullable(); //Num. Ext
            $table->string('destination_address_3',50)->nullable(); //Num Int.
            $table->string('destination_address_4',100)->nullable(); //Colonia
            $table->string('destination_address_5',100)->nullable(); //Localidad
            $table->string('destination_address_6',150)->nullable(); //Referencia
            $table->unsignedInteger('destination_city_id')->nullable(); //Municipio
            $table->unsignedInteger('destination_state_id')->nullable(); //Estado
            $table->unsignedInteger('destination_country_id')->nullable(); //Pais
            $table->string('destination_postcode',10)->nullable(); //CP
            $table->string('operator_taxid')->nullable();
            $table->string('operator_license')->nullable();
            $table->string('operator_name')->nullable();
            $table->string('operator_numid')->nullable();
            $table->unsignedInteger('operator_tr_country_id')->nullable(); //Pais
            $table->string('gross_weight')->nullable();
            $table->unsignedInteger('measure_packaging_id')->nullable();
            $table->string('net_weight')->nullable();
            $table->decimal('appraisal_fee',15,5)->default(0);
            $table->unsignedInteger('permit_type_id')->nullable();
            $table->string('permit_number')->nullable();
            $table->unsignedInteger('setting_transport_id')->nullable();
            $table->string('vehicle')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->string('name_insurer')->nullable();
            $table->string('policy_number')->nullable();
            $table->string('name_insurer2')->nullable();
            $table->string('policy_number2')->nullable();
            $table->string('name_insurer3')->nullable();
            $table->string('policy_number3')->nullable();
            $table->string('insurance_value')->nullable();
            $table->unsignedInteger('trailer_type_id_1')->nullable();
            $table->string('trailer_number_1')->nullable();
            $table->unsignedInteger('trailer_type_id_2')->nullable();
            $table->string('trailer_number_2')->nullable();
            $table->unsignedInteger('trailer_type_id_3')->nullable();
            $table->string('trailer_number_3')->nullable();
            $table->unsignedInteger('trailer_type_id_4')->nullable();
            $table->string('trailer_number_4')->nullable();
            $table->unsignedInteger('trailer_type_id_5')->nullable();
            $table->string('trailer_number_5')->nullable();
            $table->string('owner_taxid')->nullable();
            $table->string('owner_name')->nullable();
            $table->string('owner_numid')->nullable();
            $table->unsignedInteger('owner_tr_country_id')->nullable(); //Pais
            $table->unsignedInteger('owner_transport_part_id')->nullable();
            $table->string('owner_address_1',100)->nullable(); //Direccion
            $table->string('owner_address_2',50)->nullable(); //Num. Ext
            $table->string('owner_address_3',50)->nullable(); //Num Int.
            $table->string('owner_address_4',100)->nullable(); //Colonia
            $table->string('owner_address_5',100)->nullable(); //Localidad
            $table->string('owner_address_6',150)->nullable(); //Referencia
            $table->unsignedInteger('owner_city_id')->nullable(); //Municipio
            $table->unsignedInteger('owner_state_id')->nullable(); //Estado
            $table->unsignedInteger('owner_country_id')->nullable(); //Pais
            $table->string('owner_postcode',10)->nullable(); //C
            $table->string('lessee_taxid')->nullable();
            $table->string('lessee_name')->nullable();
            $table->string('lessee_numid')->nullable();
            $table->unsignedInteger('lessee_tr_country_id')->nullable(); //Pais
            $table->unsignedInteger('lessee_transport_part_id')->nullable();
            $table->string('lessee_address_1',100)->nullable(); //Direccion
            $table->string('lessee_address_2',50)->nullable(); //Num. Ext
            $table->string('lessee_address_3',50)->nullable(); //Num Int.
            $table->string('lessee_address_4',100)->nullable(); //Colonia
            $table->string('lessee_address_5',100)->nullable(); //Localidad
            $table->string('lessee_address_6',150)->nullable(); //Referencia
            $table->unsignedInteger('lessee_city_id')->nullable(); //Municipio
            $table->unsignedInteger('lessee_state_id')->nullable(); //Estado
            $table->unsignedInteger('lessee_country_id')->nullable(); //Pais
            $table->string('lessee_postcode',10)->nullable(); //C
            $table->string('notified_taxid')->nullable();
            $table->string('notified_name')->nullable();
            $table->string('notified_numid')->nullable();
            $table->unsignedInteger('notified_tr_country_id')->nullable(); //Pais

            // Index
            $table->index('id','id','BTREE');


            // Foreign
            $table->foreign('customer_invoice_id')->references('id')->on('customer_invoices')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('in_out_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('transport_type_id')->references('id')->on('transport_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('trans_transport_type_id')->references('id')->on('transport_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('source_station_type_id')->references('id')->on('station_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('source_tr_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('source_station_id')->references('id')->on('stations')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('source_city_id')->references('id')->on('cities')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('source_state_id')->references('id')->on('states')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('source_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('destination_station_type_id')->references('id')->on('station_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('destination_tr_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('destination_station_id')->references('id')->on('stations')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('destination_city_id')->references('id')->on('cities')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('destination_state_id')->references('id')->on('states')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('destination_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('operator_tr_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('measure_packaging_id')->references('id')->on('measure_packagings')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('permit_type_id')->references('id')->on('permit_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('setting_transport_id')->references('id')->on('setting_transports')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('trailer_type_id_1')->references('id')->on('trailer_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('trailer_type_id_2')->references('id')->on('trailer_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('trailer_type_id_3')->references('id')->on('trailer_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('trailer_type_id_4')->references('id')->on('trailer_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('trailer_type_id_5')->references('id')->on('trailer_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('owner_tr_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('owner_transport_part_id')->references('id')->on('transport_parts')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('owner_city_id')->references('id')->on('cities')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('owner_state_id')->references('id')->on('states')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('owner_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('lessee_tr_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('lessee_transport_part_id')->references('id')->on('transport_parts')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('lessee_city_id')->references('id')->on('cities')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('lessee_state_id')->references('id')->on('states')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('lessee_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('notified_tr_country_id')->references('id')->on('countries')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_invoice_transfers');
    }
}
