<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCartaPorteToCustomerInvoiceLineTransfers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_invoice_line_transfers', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('sat_product_id')->nullable();
            $table->unsignedInteger('sat_product_stcc_id')->nullable();
            $table->decimal('quantity',15,5)->default(0);
            $table->unsignedInteger('unit_measure_id')->nullable();
            $table->string('dimensions')->nullable();
            $table->string('dangerous_product')->nullable();
            $table->unsignedInteger('dangerous_product_id')->nullable();
            $table->unsignedInteger('packaging_type_id')->nullable();
            //$table->string('weight')->nullable();
            $table->decimal('amount_total',15,5)->default(0);
            $table->unsignedInteger('currency_id')->nullable();
            $table->unsignedInteger('tariff_fraction_id')->nullable();
            $table->string('uuid_ext')->nullable();

            // Foreign
            $table->foreign('sat_product_id')->references('id')->on('sat_products')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('sat_product_stcc_id')->references('id')->on('sat_product_stccs')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('unit_measure_id')->references('id')->on('unit_measures')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('dangerous_product_id')->references('id')->on('dangerous_products')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('packaging_type_id')->references('id')->on('packaging_types')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('currency_id')->references('id')->on('currencies')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tariff_fraction_id')->references('id')->on('tariff_fractions')->onUpdate('cascade')->onDelete('restrict');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_invoice_line_transfers', function (Blueprint $table) {
            $table->dropForeign(['sat_product_id']);
            $table->dropColumn('sat_product_id');
            $table->dropForeign(['sat_product_stcc_id']);
            $table->dropColumn('sat_product_stcc_id');
            $table->dropColumn('quantity');
            $table->dropForeign(['unit_measure_id']);
            $table->dropColumn('unit_measure_id');
            $table->dropColumn('dimensions');
            $table->dropColumn('dangerous_product');
            $table->dropForeign(['dangerous_product_id']);
            $table->dropColumn('dangerous_product_id');
            $table->dropForeign(['packaging_type_id']);
            $table->dropColumn('packaging_type_id');
            $table->dropColumn('amount_total');
            $table->dropForeign(['currency_id']);
            $table->dropColumn('currency_id');
            $table->dropForeign(['tariff_fraction_id']);
            $table->dropColumn('tariff_fraction_id');
            $table->dropColumn('uuid_ext');
        });
    }
}
