<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReasonCancellationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reason_cancellations', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            //Campos
            $table->string('name')->nullable();
            $table->string('code')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            //Index
            $table->index('id','id','BTREE');
            $table->unique('code','code','BTREE');

            //Foreign
        });

        $reason_cancellation = \App\Models\Catalogs\ReasonCancellation::updateOrCreate(
            ['code' => '01'],
            [
                'name' => 'Comprobante emitido con errores con relación',
                'sort_order' => '1'
            ]
        );

        $reason_cancellation = \App\Models\Catalogs\ReasonCancellation::updateOrCreate(
            ['code' => '02'],
            [
                'name' => 'Comprobante emitido con errores sin relación',
                'sort_order' => '2'
            ]
        );

        $reason_cancellation = \App\Models\Catalogs\ReasonCancellation::updateOrCreate(
            ['code' => '03'],
            [
                'name' => 'No se llevó a cabo la operación',
                'sort_order' => '3'
            ]
        );

        $reason_cancellation = \App\Models\Catalogs\ReasonCancellation::updateOrCreate(
            ['code' => '04'],
            [
                'name' => 'Operación nominativa relacionada en la factura global',
                'sort_order' => '4'
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reason_cancellations');
    }
}
