<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddReasonCancellationToCustomerPaymentCfdisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_payment_cfdis', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('reason_cancellation_id')->nullable();
            $table->string('reason_cancellation_uuid')->nullable();

            // Foreign
            $table->foreign('reason_cancellation_id')->references('id')->on('reason_cancellations')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_payment_cfdis', function (Blueprint $table) {
            $table->dropForeign(['reason_cancellation_id']);
            $table->dropColumn('reason_cancellation_id');
            $table->dropColumn('reason_cancellation_uuid');
        });
    }
}
