<?php

use App\Models\Catalogs\Tax;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTrasladoRetencionToTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('taxes', function (Blueprint $table) {
            //
            $table->string('type')->nullable();
        });

        Tax::where('rate','>=', 0)->update(['type' => 'T']);
        Tax::where('rate','<', 0)->update(['type' => 'R']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('taxes', function (Blueprint $table) {
            //
            $table->dropColumn('type');
        });
    }
}
