<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTaxRegimenCustomerToCustomerQuotations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_quotations', function (Blueprint $table) {
            $table->unsignedInteger('tax_regimen_customer_id')->nullable();

            // Foreign
            $table->foreign('tax_regimen_customer_id')->references('id')->on('tax_regimens')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_quotations', function (Blueprint $table) {
            $table->dropForeign(['tax_regimen_customer_id']);
            $table->dropColumn('tax_regimen_customer_id');
        });
    }
}
