<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTaxRegimenEmployeeToEmployeePayrolls extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employee_payrolls', function (Blueprint $table) {
            $table->unsignedInteger('tax_regimen_employee_id')->nullable();

            // Foreign
            $table->foreign('tax_regimen_employee_id')->references('id')->on('tax_regimens')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employee_payrolls', function (Blueprint $table) {
            $table->dropForeign(['tax_regimen_employee_id']);
            $table->dropColumn('tax_regimen_employee_id');
        });
    }
}
