<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerRemissionTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_remission_taxes', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('customer_remission_id');
            $table->string('name',100);
            $table->unsignedInteger('tax_id');
            $table->decimal('amount_base',15,5)->nullable()->default(0);
            $table->decimal('amount_tax',15,5)->nullable()->default(0);
            $table->integer('sort_order')->default(0);
            $table->boolean('status')->default(TRUE);

            // Index
            $table->index('id','id','BTREE');

            // Foreign
            $table->foreign('customer_remission_id')->references('id')->on('customer_remissions')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_remission_taxes');
    }
}
