<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerRemissionLineTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_remission_line_taxes', function (Blueprint $table) {
            // Campos
            $table->unsignedInteger('customer_remission_line_id');
            $table->unsignedInteger('tax_id');

            // Index
            $table->index('customer_remission_line_id','customer_remission_line_id','BTREE');
            $table->index('tax_id','tax_id','BTREE');

            // Llave primaria
            $table->primary(['customer_remission_line_id','tax_id'],'cil_customer_remission_line_id_tax_id_pk');

            // Foreign
            $table->foreign('customer_remission_line_id')->references('id')->on('customer_remission_lines')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_remission_line_taxes');
    }
}
