<?php

use App\Models\Base\DocumentType;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCustomerRemissionToDocumentTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('document_types', function (Blueprint $table) {
            $document_types = DocumentType::where('code','customer.remission')->get();
            if($document_types->isEmpty()){
                $companies = \App\Models\Base\Company::active()->orderBy('id')->get();
                foreach($companies as $company){
                    DocumentType::create([
                        'name' => 'Nota de venta',
                        'code' => 'customer.remission',
                        'prefix' => 'CVN',
                        'current_number' => 0,
                        'increment_number' => 1,
                        'nature' => \App\Models\Base\DocumentType::NO_NATURE,
                        'cfdi_type_id' => null,
                        'sort_order' => 9,
                        'status' => 1,
                        'company_id' => $company->id,
                    ]);
                }
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('document_types', function (Blueprint $table) {
            //
        });
    }
}
