<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomerInvoiceComplementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_invoice_complements', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamps();
            $table->unsignedInteger('created_uid')->nullable();
            $table->unsignedInteger('updated_uid')->nullable();

            // Campos
            $table->unsignedInteger('customer_invoice_id');
            $table->string('ine_process_type')->nullable();
            $table->string('ine_committee_type')->nullable();
            $table->integer('ine_id_accounting')->nullable();

            // Index
            $table->index('id','id','BTREE');
            $table->index('customer_invoice_id','customer_invoice_id','BTREE');

            // Foreign
            $table->foreign('customer_invoice_id')->references('id')->on('customer_invoices')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_invoice_complements');
    }
}
