<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTaxesToCustomerPaymentReconcileds extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('customer_payment_reconcileds', function (Blueprint $table) {
            $table->unsignedInteger('tax_id_1')->nullable();
            $table->decimal('amount_base_1',15,5)->nullable()->default(0);
            $table->unsignedInteger('tax_id_2')->nullable();
            $table->decimal('amount_base_2',15,5)->nullable()->default(0);
            $table->unsignedInteger('tax_id_3')->nullable();
            $table->decimal('amount_base_3',15,5)->nullable()->default(0);
            $table->unsignedInteger('tax_id_4')->nullable();
            $table->decimal('amount_base_4',15,5)->nullable()->default(0);
            $table->unsignedInteger('tax_id_5')->nullable();
            $table->decimal('amount_base_5',15,5)->nullable()->default(0);
            $table->decimal('amount_total',15,5)->nullable()->default(0);

            // Foreign
            $table->foreign('tax_id_1')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id_2')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id_3')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id_4')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
            $table->foreign('tax_id_5')->references('id')->on('taxes')->onUpdate('cascade')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('customer_payment_reconcileds', function (Blueprint $table) {
            $table->dropForeign(['tax_id_1']);
            $table->dropColumn('tax_id_1');
            $table->dropColumn('amount_base_1');
            $table->dropForeign(['tax_id_2']);
            $table->dropColumn('tax_id_2');
            $table->dropColumn('amount_base_2');
            $table->dropForeign(['tax_id_3']);
            $table->dropColumn('tax_id_3');
            $table->dropColumn('amount_base_3');
            $table->dropForeign(['tax_id_4']);
            $table->dropColumn('tax_id_4');
            $table->dropColumn('amount_base_4');
            $table->dropForeign(['tax_id_5']);
            $table->dropColumn('tax_id_5');
            $table->dropColumn('amount_base_5');
            $table->dropColumn('amount_total');
        });
    }
}
