<?php

use App\Models\Base\Setting;
use App\Models\Catalogs\State;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\Postcode;
use App\Models\Catalogs\TaxRegimen;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class EnableCfdi40 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Setting::where('key','cfdi_version')->update(['value' => 'cfdi40']);

        $cfdi_uses = CfdiUse::whereIn('code', ['P01'])->update([
            'status' => '0'
        ]);
        $cfdi_uses = CfdiUse::whereIn('code', ['S01','CP01','CN01'])->update([
            'status' => '1'
        ]);

        $tax_regimens = TaxRegimen::whereIn('code', ['616'])->update([
            'status' => '1'
        ]);
        State::whereIn('code', ['DIF'])->update([
            'code' => 'CMX'
        ]);
        Postcode::whereIn('code_state', ['DIF'])->update([
            'code_state' => 'CMX'
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
