<?php

use App\Models\Auth\User;
use App\Models\Base\BranchOffice;
use App\Models\Base\Company;
use App\Models\Base\CompanyBankAccount;
use App\Models\Base\DocumentType;
use App\Models\Base\Pac;
use App\Models\Base\Setting;
use App\Models\Catalogs\Bank;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Catalogs\CfdiType;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\IeduNivelEducativo;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\Product;
use App\Models\Catalogs\SatProduct;
use App\Models\Catalogs\Tax;
use App\Models\Catalogs\TaxRegimen;
use App\Models\Catalogs\UnitMeasure;
use App\Models\Catalogs\State;
use App\Models\Sales\Customer;
use App\Models\Sales\CustomerBankAccount;
use App\Models\Sales\CustomerIedu;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerInvoiceCfdi;
use App\Models\Sales\CustomerInvoiceLine;
use App\Models\Sales\CustomerInvoiceLineComplement;
use App\Models\Sales\CustomerInvoiceLineTax;
use App\Models\Sales\CustomerInvoiceReconciled;
use App\Models\Sales\CustomerInvoiceRelation;
use App\Models\Sales\CustomerInvoiceTax;
use App\Models\Sales\CustomerPayment;
use App\Models\Sales\CustomerPaymentCfdi;
use App\Models\Sales\CustomerPaymentReconciled;
use App\Models\Sales\CustomerPaymentRelation;
use App\Models\Sales\Salesperson;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;


class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        factory(\App\Models\Auth\User::class, 1)->create([
            'name' => 'F. Angel Hernández C.',
            'email' => 'sksistemas@hotmail.com',
            'password' => bcrypt('secret'),
            'sort_order' => 0,
            'status' => 1,
        ]);

        $user = \App\Models\Auth\User::where('email','=','sksistemas@hotmail.com')->get()->first();
        $user->superadmin = 1;
        $user->save();

        factory(\App\Models\Shop\ShopTax::class, 1)->create([
            'name' => 'IVA 16%',
            'code' => \App\Models\Catalogs\Tax::IVA,
            'rate' => 16.0,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 1,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::TRASLADO
        ]);
    }
}
