<?php

use App\Helpers\Helper;
use App\Models\Auth\User;
use App\Models\Base\BranchOffice;
use App\Models\Base\Company;
use App\Models\Base\CompanyBankAccount;
use App\Models\Base\DocumentType;
use App\Models\Base\Pac;
use App\Models\Base\Setting;
use App\Models\Catalogs\Bank;
use App\Models\Catalogs\CfdiRelation;
use App\Models\Catalogs\CfdiType;
use App\Models\Catalogs\CfdiUse;
use App\Models\Catalogs\City;
use App\Models\Catalogs\Country;
use App\Models\Catalogs\Currency;
use App\Models\Catalogs\IeduNivelEducativo;
use App\Models\Catalogs\PaymentMethod;
use App\Models\Catalogs\PaymentTerm;
use App\Models\Catalogs\PaymentWay;
use App\Models\Catalogs\Product;
use App\Models\Catalogs\SatProduct;
use App\Models\Catalogs\Tax;
use App\Models\Catalogs\TaxRegimen;
use App\Models\Catalogs\UnitMeasure;
use App\Models\Catalogs\State;
use App\Models\Sales\Customer;
use App\Models\Sales\CustomerBankAccount;
use App\Models\Sales\CustomerIedu;
use App\Models\Sales\CustomerInvoice;
use App\Models\Sales\CustomerInvoiceCfdi;
use App\Models\Sales\CustomerInvoiceLine;
use App\Models\Sales\CustomerInvoiceLineComplement;
use App\Models\Sales\CustomerInvoiceLineTransfer;
use App\Models\Sales\CustomerInvoiceReconciled;
use App\Models\Sales\CustomerInvoiceRelation;
use App\Models\Sales\CustomerInvoiceTax;
use App\Models\Sales\CustomerPayment;
use App\Models\Sales\CustomerPaymentCfdi;
use App\Models\Sales\CustomerPaymentReconciled;
use App\Models\Sales\CustomerPaymentRelation;
use App\Models\Sales\Salesperson;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;


class TenantSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        //Deshabilita fk
        Schema::disableForeignKeyConstraints();

        //Elimina tablas
        Setting::truncate();
        \DB::table('password_resets')->truncate(); //Se elimina antes para evitar errores
        //User::truncate();
        Pac::truncate();
        UnitMeasure::truncate();
        SatProduct::truncate();
        PaymentWay::truncate();
        PaymentMethod::truncate();
        TaxRegimen::truncate();
        CfdiType::truncate();
        CfdiRelation::truncate();
        CfdiUse::truncate();
        Currency::truncate();
        Tax::truncate();
        DocumentType::truncate();
        Bank::truncate();
        Salesperson::truncate();
        PaymentTerm::truncate();
        City::truncate(); //Se elimina antes para evitar errores
        State::truncate(); //Se elimina antes para evitar errores
        Country::truncate();
        CompanyBankAccount::truncate();
        Company::truncate();
        BranchOffice::truncate();
        CustomerBankAccount::truncate();
        Customer::truncate();
        \DB::table('product_taxes')->truncate(); //Se elimina antes para evitar errores
        Product::truncate();
        CustomerInvoiceTax::truncate(); //Se elimina antes para evitar errores
        \DB::table('customer_invoice_line_taxes')->truncate(); //Se elimina antes para evitar errores
        CustomerInvoiceLine::truncate(); //Se elimina antes para evitar errores
        CustomerInvoiceRelation::truncate(); //Se elimina antes para evitar errores
        CustomerInvoiceReconciled::truncate(); //Se elimina antes para evitar errores
        CustomerInvoiceCfdi::truncate(); //Se elimina antes para evitar errores
        CustomerInvoice::truncate();
        CustomerPaymentRelation::truncate(); //Se elimina antes para evitar errores
        CustomerPaymentReconciled::truncate(); //Se elimina antes para evitar errores
        CustomerPaymentCfdi::truncate(); //Se elimina antes para evitar errores
        CustomerPayment::truncate();
        IeduNivelEducativo::truncate();
        CustomerIedu::truncate();
        CustomerInvoiceLineComplement::truncate();
        CustomerInvoiceLineTransfer::truncate();
        \App\Models\Catalogs\Pediment::truncate();
        \App\Models\Catalogs\TariffFraction::truncate();
        \App\Models\Catalogs\Incoterm::truncate();
        \App\Models\Catalogs\TransferReason::truncate();
        \App\Models\Catalogs\OperationType::truncate();
        \App\Models\Catalogs\UomCustom::truncate();
        \App\Models\Sales\CustomerQuotationTax::truncate(); //Se elimina antes para evitar errores
        \DB::table('customer_quotation_line_taxes')->truncate(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerQuotationLine::truncate(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerQuotation::truncate();
        \App\Models\Catalogs\Postcode::truncate();
        \App\Models\Catalogs\SourceResource::truncate();
        \App\Models\Catalogs\FrequencyPayment::truncate();
        \App\Models\Catalogs\ContractType::truncate();
        \App\Models\Catalogs\Deduction::truncate();
        \App\Models\Catalogs\OvertimesType::truncate();
        \App\Models\Catalogs\DisabilityType::truncate();
        \App\Models\Catalogs\WorkdayType::truncate();
        \App\Models\Catalogs\PayrollType::truncate();
        \App\Models\Catalogs\OtherPaymentType::truncate();
        \App\Models\Catalogs\Perception::truncate();
        \App\Models\Catalogs\RecruitmentRegime::truncate();
        \App\Models\Catalogs\JobRiskClasse::truncate();
        \App\Models\Base\Employee::truncate();
        \App\Models\Base\EmployeePayrollLine::truncate();
        \App\Models\Base\EmployeePayrollCfdi::truncate();
        \App\Models\Base\EmployeePayrollRelation::truncate();
        \App\Models\Base\EmployeePayrollOutsourcing::truncate();
        \App\Models\Base\EmployeePayrollOutsourcing::truncate();
        \App\Models\Base\EmployeePayroll::truncate();
        \App\Models\Base\Payroll::truncate();
        \App\Models\Base\EmployeeCategory::truncate();
        \App\Models\Catalogs\ExpenseType::truncate();
        \App\Models\Catalogs\Project::truncate();
        \App\Models\Sales\RecurringCustomerInvoiceTax::truncate(); //Se elimina antes para evitar errores
        \DB::table('recurring_customer_invoice_line_taxes')->truncate(); //Se elimina antes para evitar errores
        \App\Models\Sales\RecurringCustomerInvoiceLine::truncate(); //Se elimina antes para evitar errores
        \App\Models\Sales\RecurringCustomerInvoice::truncate();
        \App\Models\Sales\RecurringCustomerInvoiceLineComplement::truncate();
        \App\Models\Sales\RecurringCustomerInvoiceLineTransfer::truncate();
        \App\Models\Base\CfdiDownload::truncate();
        \App\Models\Base\CfdiDownloadPayment::truncate();
        \App\Models\Catalogs\OperationalType::truncate();
        \App\Models\Base\BankMoveTemp::truncate();
        \App\Models\Base\BankReconciliation::truncate();
        \App\Models\Base\BankReconciliationLineTemp::truncate();
        \App\Models\Base\BankMoveTemp::truncate();
        \App\Models\Base\BankMoveTempReconciled::truncate();
        \App\Models\Base\BankReconciliationLine::truncate();
        \App\Models\Base\BankMove::truncate();
        \App\Models\Base\BankMoveReconciled::truncate();
        \App\Models\Base\BankReconciliationUnreconcile::truncate();
        \App\Models\Base\CfdiDownloadRequest::truncate();
        \App\Models\Base\Diot::truncate();
        \App\Models\Base\DiotLine::truncate();
        \App\Models\Sales\CustomerInvoiceTaxLegend::truncate();
        \App\Models\Catalogs\AuthorizationAgent::truncate();
        \App\Models\Catalogs\CarType::truncate();
        \App\Models\Catalogs\ContainerMaritime::truncate();
        \App\Models\Catalogs\ContainerType::truncate();
        \App\Models\Catalogs\DangerousProduct::truncate();
        \App\Models\Catalogs\LoadType::truncate();
        \App\Models\Catalogs\MeasurePackaging::truncate();
        \App\Models\Catalogs\PackagingType::truncate();
        \App\Models\Catalogs\PermitType::truncate();
        \App\Models\Catalogs\RightsWay::truncate();
        \App\Models\Catalogs\SatProductStcc::truncate();
        \App\Models\Catalogs\ServiceType::truncate();
        \App\Models\Catalogs\SettingMaritime::truncate();
        \App\Models\Catalogs\SettingTransport::truncate();
        \App\Models\Catalogs\Station::truncate();
        \App\Models\Catalogs\StationType::truncate();
        \App\Models\Catalogs\TrailerType::truncate();
        \App\Models\Catalogs\TransportAerial::truncate();
        \App\Models\Catalogs\TransportFigure::truncate();
        \App\Models\Catalogs\TransportPart::truncate();
        \App\Models\Catalogs\TransportType::truncate();
        \App\Models\Catalogs\TrafficType::truncate();
        \App\Models\Sales\CustomerInvoiceTransfer::truncate();
        \App\Models\Catalogs\ReasonCancellation::truncate();
        \App\Models\Base\Announcement::truncate();
        \App\Models\Sales\CustomerRemissionTax::truncate(); //Se elimina antes para evitar errores
        \DB::table('customer_remission_line_taxes')->truncate(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerRemissionLine::truncate(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerRemission::truncate();
        \App\Models\Sales\CustomerInvoiceComplement::truncate();
        \App\Models\Sales\CustomerInvoiceIne::truncate();

        //En caso de haber un listener en los modelos para evitar problemas con acciones predefinidas
        Setting::flushEventListeners();
        //\DB::table('password_resets')->flushEventListeners(); //Se elimina antes para evitar errores
        //User::flushEventListeners();
        Pac::flushEventListeners();
        UnitMeasure::flushEventListeners();
        SatProduct::flushEventListeners();
        PaymentWay::flushEventListeners();
        PaymentMethod::flushEventListeners();
        TaxRegimen::flushEventListeners();
        CfdiType::flushEventListeners();
        CfdiRelation::flushEventListeners();
        CfdiUse::flushEventListeners();
        Currency::flushEventListeners();
        Tax::flushEventListeners();
        DocumentType::flushEventListeners();
        Bank::flushEventListeners();
        Salesperson::flushEventListeners();
        PaymentTerm::flushEventListeners();
        Country::flushEventListeners();
        State::flushEventListeners();
        City::flushEventListeners();
        CompanyBankAccount::flushEventListeners();
        Company::flushEventListeners();
        BranchOffice::flushEventListeners();
        CustomerBankAccount::flushEventListeners();
        Customer::flushEventListeners();
        //\DB::table('product_taxes')->flushEventListeners(); //Se elimina antes para evitar errores
        Product::flushEventListeners();
        CustomerInvoiceTax::flushEventListeners();
        //\DB::table('customer_invoice_line_taxes')->flushEventListeners(); //Se elimina antes para evitar errores
        CustomerInvoiceLine::flushEventListeners();
        CustomerInvoiceRelation::flushEventListeners();
        CustomerInvoiceReconciled::flushEventListeners();
        CustomerInvoiceCfdi::flushEventListeners();
        CustomerInvoice::flushEventListeners();
        CustomerPaymentRelation::flushEventListeners();
        CustomerPaymentReconciled::flushEventListeners();
        CustomerPaymentCfdi::flushEventListeners();
        CustomerPayment::flushEventListeners();
        IeduNivelEducativo::flushEventListeners();
        CustomerIedu::flushEventListeners();
        CustomerInvoiceLineComplement::flushEventListeners();
        CustomerInvoiceLineTransfer::flushEventListeners();
        \App\Models\Catalogs\Pediment::flushEventListeners();
        \App\Models\Catalogs\TariffFraction::flushEventListeners();
        \App\Models\Catalogs\Incoterm::flushEventListeners();
        \App\Models\Catalogs\TransferReason::flushEventListeners();
        \App\Models\Catalogs\OperationType::flushEventListeners();
        \App\Models\Catalogs\UomCustom::flushEventListeners();
        \App\Models\Sales\CustomerQuotationTax::flushEventListeners(); //Se elimina antes para evitar errores
        //\DB::table('customer_quotation_line_taxes')->flushEventListeners(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerQuotationLine::flushEventListeners(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerQuotation::flushEventListeners();
        \App\Models\Catalogs\Postcode::flushEventListeners();
        \App\Models\Catalogs\SourceResource::flushEventListeners();
        \App\Models\Catalogs\FrequencyPayment::flushEventListeners();
        \App\Models\Catalogs\ContractType::flushEventListeners();
        \App\Models\Catalogs\Deduction::flushEventListeners();
        \App\Models\Catalogs\OvertimesType::flushEventListeners();
        \App\Models\Catalogs\DisabilityType::flushEventListeners();
        \App\Models\Catalogs\WorkdayType::flushEventListeners();
        \App\Models\Catalogs\PayrollType::flushEventListeners();
        \App\Models\Catalogs\OtherPaymentType::flushEventListeners();
        \App\Models\Catalogs\Perception::flushEventListeners();
        \App\Models\Catalogs\RecruitmentRegime::flushEventListeners();
        \App\Models\Catalogs\JobRiskClasse::flushEventListeners();
        \App\Models\Base\Employee::flushEventListeners();
        \App\Models\Base\EmployeePayrollLine::flushEventListeners();
        \App\Models\Base\EmployeePayrollCfdi::flushEventListeners();
        \App\Models\Base\EmployeePayrollRelation::flushEventListeners();
        \App\Models\Base\EmployeePayrollOutsourcing::flushEventListeners();
        \App\Models\Base\EmployeePayroll::flushEventListeners();
        \App\Models\Base\Payroll::flushEventListeners();
        \App\Models\Base\EmployeeCategory::flushEventListeners();
        \App\Models\Catalogs\Project::flushEventListeners();
        \App\Models\Sales\RecurringCustomerInvoiceTax::flushEventListeners(); //Se elimina antes para evitar errores
        //\DB::table('recurring_customer_invoice_line_taxes')->flushEventListeners(); //Se elimina antes para evitar errores
        \App\Models\Sales\RecurringCustomerInvoiceLine::flushEventListeners(); //Se elimina antes para evitar errores
        \App\Models\Sales\RecurringCustomerInvoice::flushEventListeners();
        \App\Models\Sales\RecurringCustomerInvoiceLineComplement::flushEventListeners();
        \App\Models\Sales\RecurringCustomerInvoiceLineTransfer::flushEventListeners();
        \App\Models\Base\CfdiDownload::flushEventListeners();
        \App\Models\Base\CfdiDownloadPayment::flushEventListeners();
        \App\Models\Catalogs\OperationalType::flushEventListeners();
        \App\Models\Base\BankMoveTemp::flushEventListeners();
        \App\Models\Base\BankReconciliation::flushEventListeners();
        \App\Models\Base\BankReconciliationLineTemp::flushEventListeners();
        \App\Models\Base\BankMoveTemp::flushEventListeners();
        \App\Models\Base\BankMoveTempReconciled::flushEventListeners();
        \App\Models\Base\BankReconciliationLine::flushEventListeners();
        \App\Models\Base\BankMove::flushEventListeners();
        \App\Models\Base\BankMoveReconciled::flushEventListeners();
        \App\Models\Base\BankReconciliationUnreconcile::flushEventListeners();
        \App\Models\Base\CfdiDownloadRequest::flushEventListeners();
        \App\Models\Base\Diot::flushEventListeners();
        \App\Models\Base\DiotLine::flushEventListeners();
        \App\Models\Sales\CustomerInvoiceTaxLegend::flushEventListeners();
        \App\Models\Catalogs\AuthorizationAgent::flushEventListeners();
        \App\Models\Catalogs\CarType::flushEventListeners();
        \App\Models\Catalogs\ContainerMaritime::flushEventListeners();
        \App\Models\Catalogs\ContainerType::flushEventListeners();
        \App\Models\Catalogs\DangerousProduct::flushEventListeners();
        \App\Models\Catalogs\LoadType::flushEventListeners();
        \App\Models\Catalogs\MeasurePackaging::flushEventListeners();
        \App\Models\Catalogs\PackagingType::flushEventListeners();
        \App\Models\Catalogs\PermitType::flushEventListeners();
        \App\Models\Catalogs\RightsWay::flushEventListeners();
        \App\Models\Catalogs\SatProductStcc::flushEventListeners();
        \App\Models\Catalogs\ServiceType::flushEventListeners();
        \App\Models\Catalogs\SettingMaritime::flushEventListeners();
        \App\Models\Catalogs\SettingTransport::flushEventListeners();
        \App\Models\Catalogs\Station::flushEventListeners();
        \App\Models\Catalogs\StationType::flushEventListeners();
        \App\Models\Catalogs\TrailerType::flushEventListeners();
        \App\Models\Catalogs\TransportAerial::flushEventListeners();
        \App\Models\Catalogs\TransportFigure::flushEventListeners();
        \App\Models\Catalogs\TransportPart::flushEventListeners();
        \App\Models\Catalogs\TransportType::flushEventListeners();
        \App\Models\Catalogs\TrafficType::flushEventListeners();
        \App\Models\Sales\CustomerInvoiceTransfer::flushEventListeners();
        \App\Models\Catalogs\ReasonCancellation::flushEventListeners();
        \App\Models\Base\Announcement::flushEventListeners();
        \App\Models\Sales\CustomerRemissionTax::flushEventListeners(); //Se elimina antes para evitar errores
        //\DB::table('customer_remission_line_taxes')->flushEventListeners(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerRemissionLine::flushEventListeners(); //Se elimina antes para evitar errores
        \App\Models\Sales\CustomerRemission::flushEventListeners();
        \App\Models\Sales\CustomerInvoiceComplement::flushEventListeners();
        \App\Models\Sales\CustomerInvoiceIne::flushEventListeners();

        //Configuracion
        Setting::create([
            'key' => 'product_price_decimal_place',
            'value' => '2',
        ]);
        Setting::create([
            'key' => 'cfdi_version',
            'value' => 'cfdi40',
        ]);
        Setting::create([
            'key' => 'color_primary',
            'value' => '#999999',
        ]);
        Setting::create([
            'key' => 'list_limit',
            'value' => '100',
        ]);
        Setting::create([
            'key' => 'decimal_mark',
            'value' => '.',
        ]);
        Setting::create([
            'key' => 'thousands_separator',
            'value' => ',',
        ]);
        Setting::create([
            'key' => 'date_format',
            'value' => 'd-m-Y',
        ]);
        Setting::create([
            'key' => 'datetime_format',
            'value' => 'd-m-Y H:i:s',
        ]);
        Setting::create([
            'key' => 'date_picker_format',
            'value' => 'DD-MM-YYYY',
        ]);
        Setting::create([
            'key' => 'datetime_picker_format',
            'value' => 'DD-MM-YYYY HH:mm:ss',
        ]);
        Setting::create([
            'key' => 'complemento_cfdi_iedu',
            'value' => '0',
        ]);
        Setting::create([
            'key' => 'app_demo',
            'value' => '0',
        ]);
        Setting::create([
            'key' => 'app_installation_step',
            'value' => '5',
        ]);
        Setting::create([
            'key' => 'multi_taxid',
            'value' => '0',
        ]);

        //creamos directorio default
        $taxid = Str::random(14);
        /*$path = $taxid;
        if(!\Storage::exists($path)) {
            \Storage::makeDirectory($path, 0777, true); //creates directory
        }*/

        //Usuarios
        /*$path_user_avatars = $taxid .'/'. \App\Models\Auth\User::PATH_AVATARS;
        if(!\Storage::exists($path_user_avatars)) {
            \Storage::makeDirectory($path_user_avatars, 0777, true); //creates directory
        }
        factory(\App\Models\Auth\User::class, 1)->create([
            'name' => 'F. Angel Hernández C.',
            'email' => 'sksistemas@hotmail.com',
            'password' => bcrypt('secret'),
            'avatar' => null,
            'sort_order' => 0,
            'status' => 1,
        ]);*/

        //Pacs
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'PAC Pruebas',
            'code' => 'pacTest',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'EDICM Pruebas',
            'code' => 'edicomTest',
            'ws_url' => 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl',
            'ws_url_cancel' => 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'FNKO Pruebas',
            'code' => 'finkokTest',
            'ws_url' => 'https://demo-facturacion.finkok.com/servicios/soap/stamp.wsdl',
            'ws_url_cancel' => 'https://demo-facturacion.finkok.com/servicios/soap/cancel.wsdl',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'EDICM Producción',
            'code' => 'edicom',
            'ws_url' => 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl',
            'ws_url_cancel' => 'https://cfdiws.sedeb2b.com/EdiwinWS/services/CFDi?wsdl',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'FNKO Producción',
            'code' => 'finkok',
            'ws_url' => 'https://facturacion.finkok.com/servicios/soap/stamp.wsdl',
            'ws_url_cancel' => 'https://facturacion.finkok.com/servicios/soap/cancel.wsdl',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'TIMBOX Pruebas',
            'code' => 'timboxTest',
            'ws_url' => 'https://staging.ws.timbox.com.mx/timbrado_cfdi33/wsdl',
            'ws_url_cancel' => 'https://staging.ws.timbox.com.mx/cancelacion/wsdl',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'TIMBOX Producción',
            'code' => 'timbox',
            'ws_url' => 'https://sistema.timbox.com.mx/timbrado_cfdi33/wsdl',
            'ws_url_cancel' => 'https://sistema.timbox.com.mx/cancelacion/wsdl',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Comercio Digital Pruebas',
            'code' => 'comdigTest',
            'ws_url' => 'https://pruebas.comercio-digital.mx/timbre/timbrarV5.aspx',
            'ws_url_cancel' => 'https://pruebas.comercio-digital.mx/cancela4/cancelarUuid',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Comercio Digital Producción',
            'code' => 'comdig',
            'ws_url' => 'https://ws.comercio-digital.mx/timbre/timbrarV5.aspx',
            'ws_url_cancel' => 'https://cancela.comercio-digital.mx/cancela4/cancelarUuid',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Multifacturas Pruebas',
            'code' => 'multifacturasTest',
            'ws_url' => 'http://pac1.multifacturas.com/pac/?wsdl',
            'ws_url_cancel' => 'http://pac1.facturacionmexico.com.mx/cancelacion2022/?wsdl',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Multifacturas Producción',
            'code' => 'multifacturas',
            'ws_url' => 'http://pac1.multifacturas.com/pac/?wsdl',
            'ws_url_cancel' => 'http://pac1.facturacionmexico.com.mx/cancelacion2022/?wsdl',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Sifei Pruebas',
            'code' => 'sifeiTest',
            'ws_url' => 'http://devcfdi.sifei.com.mx:8080/SIFEI33/SIFEI?wsdl',
            'ws_url_cancel' => 'http://devcfdi.sifei.com.mx:8888/CancelacionSIFEI/Cancelacion?wsdl',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Sifei Producción',
            'code' => 'sifei',
            'ws_url' => 'https://sat.sifei.com.mx:8443/SIFEI/SIFEI?wsdl',
            'ws_url_cancel' => 'https://sat.sifei.com.mx:9000/CancelacionSIFEI/Cancelacion?wsdl',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        /*factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'SW Sapien Pruebas',
            'code' => 'swsapienTest',
            'ws_url' => 'http://services.test.sw.com.mx',
            'ws_url_cancel' => 'http://services.test.sw.com.mx',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'SW Sapien',
            'code' => 'swsapien',
            'ws_url' => 'https://services.sw.com.mx',
            'ws_url_cancel' => 'https://services.sw.com.mx',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);*/
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'InvoiceOne Pruebas',
            'code' => 'invoiceOneTest',
            'ws_url' => 'https://invoiceone.mx/TimbreCFDI/TimbreCFDI.asmx?WSDL',
            'ws_url_cancel' => 'https://invoiceone.mx/TimbreCFDI/TimbreCFDI.asmx?WSDL',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'InvoiceOne',
            'code' => 'invoiceOne',
            'ws_url' => 'https://invoiceone.mx/TimbreCFDI/TimbreCFDI.asmx?WSDL',
            'ws_url_cancel' => 'https://invoiceone.mx/TimbreCFDI/TimbreCFDI.asmx?WSDL',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'TimbradorXpress Pruebas',
            'code' => 'timbradorXpressTest',
            'ws_url' => 'https://dev.timbradorxpress.mx/ws/servicio.do?wsdl',
            'ws_url_cancel' => 'https://dev.timbradorxpress.mx/ws/servicio.do?wsdl',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'TimbradorXpress Producción',
            'code' => 'timbradorXpress',
            'ws_url' => 'https://app.timbradorxpress.mx/ws/servicio.do?wsdl',
            'ws_url_cancel' => 'https://app.timbradorxpress.mx/ws/servicio.do?wsdl',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Virtual Pac Pruebas',
            'code' => 'virtualPacTest',
            'ws_url' => 'https://virtual-pac.mx/timbrado/WebService1.asmx?WSDL',
            'ws_url_cancel' => 'https://virtual-pac.mx/timbrado/CancelacionesWS.asmx?WSDL',
            'test' => TRUE,
            'status' => Helper::testEnvironment() ? 1 : 0,
        ]);
        factory(\App\Models\Base\Pac::class, 1)->create([
            'name' => 'Virtual Pac Producción',
            'code' => 'virtualPac',
            'ws_url' => 'https://virtual-pac.mx/timbrado/WebService1.asmx?WSDL',
            'ws_url_cancel' => 'https://virtual-pac.mx/timbrado/CancelacionesWS.asmx?WSDL',
            'test' => FALSE,
            'status' => Helper::testEnvironment() ? 0 : 1,
        ]);

        //Default PAC
        if(Helper::testEnvironment()) {
            Setting::create([
                'key' => 'default_pac_id',
                'value' => \App\Models\Base\Pac::where('code', '=', 'pacTest')->get()->first()->id,
            ]);
        }else{
            Setting::create([
                'key' => 'default_pac_id',
                'value' => \App\Models\Base\Pac::where('code', '=', 'finkok')->get()->first()->id,
            ]);
        }

        //Unidades de medida
        $sql_unit_measure = \Storage::path('sql/unit_measure.sql');
        \DB::connection('tenant')->unprepared(file_get_contents($sql_unit_measure));

        //Productos y servicios SAT
        $sql_sat_product = \Storage::path('sql/sat_product.sql');
        \DB::connection('tenant')->unprepared(file_get_contents($sql_sat_product));

        //Formas de pago
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Efectivo',
            'code' => '01',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Cheque nominativo',
            'code' => '02',
            'patron_cuenta_ordenante' => '[0-9]{11}|[0-9]{18}',
            'patron_cuenta_beneficiaria' => '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Transferencia electrónica de fondos',
            'code' => '03',
            'patron_cuenta_ordenante' => '[0-9]{10}|[0-9]{16}|[0-9]{18}',
            'patron_cuenta_beneficiaria' => '[0-9]{10}|[0-9]{18}',
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Tarjeta de crédito',
            'code' => '04',
            'patron_cuenta_ordenante' => '[0-9]{16}',
            'patron_cuenta_beneficiaria' => '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}',
            'sort_order' => 4,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Monedero electrónico',
            'code' => '05',
            'patron_cuenta_ordenante' => '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}',
            'patron_cuenta_beneficiaria' => '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}',
            'sort_order' => 5,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Dinero electrónico',
            'code' => '06',
            'sort_order' => 6,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Vales de despensa',
            'code' => '08',
            'sort_order' => 7,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Dación en pago',
            'code' => '12',
            'sort_order' => 8,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Pago por subrogación',
            'code' => '13',
            'sort_order' => 9,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Pago por consignación',
            'code' => '14',
            'sort_order' => 10,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Condonación',
            'code' => '15',
            'sort_order' => 11,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Compensación',
            'code' => '17',
            'sort_order' => 12,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Novación',
            'code' => '23',
            'sort_order' => 13,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Confusión',
            'code' => '24',
            'sort_order' => 14,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Remisión de deuda',
            'code' => '25',
            'sort_order' => 15,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Prescripción o caducidad',
            'code' => '26',
            'sort_order' => 16,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'A satisfacción del acreedor',
            'code' => '27',
            'sort_order' => 17,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Tarjeta de débito',
            'code' => '28',
            'patron_cuenta_ordenante' => '[0-9]{16}',
            'patron_cuenta_beneficiaria' => '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}',
            'sort_order' => 18,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Tarjeta de servicios',
            'code' => '29',
            'patron_cuenta_ordenante' => '[0-9]{15,16}',
            'patron_cuenta_beneficiaria' => '[0-9]{10,11}|[0-9]{15,16}|[0-9]{18}|[A-Z0-9_]{10,50}',
            'sort_order' => 19,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Aplicación de anticipos',
            'code' => '30',
            'sort_order' => 20,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Intermediario pagos',
            'code' => '31',
            'sort_order' => 21,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\PaymentWay::class, 1)->create([
            'name' => 'Por definir',
            'code' => '99',
            'sort_order' => 22,
            'status' => 1,
        ]);

        //Metodos de pago
        factory(\App\Models\Catalogs\PaymentMethod::class, 1)->create([
            'name' => 'Pago en una sola exhibición',
            'code' => 'PUE',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentMethod::class, 1)->create([
            'name' => 'Pago en parcialidades o diferido',
            'code' => 'PPD',
            'sort_order' => 2,
            'status' => 1,
        ]);

        //Regimen fiscal
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'General de Ley Personas Morales',
            'code' => '601',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Personas Morales con Fines no Lucrativos',
            'code' => '603',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Sueldos y Salarios e Ingresos Asimilados a Salarios',
            'code' => '605',
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Arrendamiento',
            'code' => '606',
            'sort_order' => 4,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Demás ingresos',
            'code' => '608',
            'sort_order' => 5,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Consolidación',
            'code' => '609',
            'sort_order' => 6,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Residentes en el Extranjero sin Establecimiento Permanente en México',
            'code' => '610',
            'sort_order' => 7,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Ingresos por Dividendos (socios y accionistas)',
            'code' => '611',
            'sort_order' => 8,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Personas Físicas con Actividades Empresariales y Profesionales',
            'code' => '612',
            'sort_order' => 9,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Ingresos por intereses',
            'code' => '614',
            'sort_order' => 10,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Sin obligaciones fiscales',
            'code' => '616',
            'sort_order' => 11,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Sociedades Cooperativas de Producción que optan por diferir sus ingresos',
            'code' => '620',
            'sort_order' => 12,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Incorporación Fiscal',
            'code' => '621',
            'sort_order' => 13,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras',
            'code' => '622',
            'sort_order' => 14,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Opcional para Grupos de Sociedades',
            'code' => '623',
            'sort_order' => 15,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Coordinados',
            'code' => '624',
            'sort_order' => 16,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Hidrocarburos',
            'code' => '628',
            'sort_order' => 17,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Régimen de Enajenación o Adquisición de Bienes',
            'code' => '607',
            'sort_order' => 18,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'De los Regímenes Fiscales Preferentes y de las Empresas Multinacionales',
            'code' => '629',
            'sort_order' => 19,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Enajenación de acciones en bolsa de valores',
            'code' => '630',
            'sort_order' => 20,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\TaxRegimen::class, 1)->create([
            'name' => 'Régimen de los ingresos por obtención de premios',
            'code' => '615',
            'sort_order' => 21,
            'status' => 0,
        ]);

        //Tipos de comprobante
        factory(\App\Models\Catalogs\CfdiType::class, 1)->create([
            'name' => 'Ingreso',
            'code' => 'I',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiType::class, 1)->create([
            'name' => 'Egreso',
            'code' => 'E',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiType::class, 1)->create([
            'name' => 'Pago',
            'code' => 'P',
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiType::class, 1)->create([
            'name' => 'Traslado',
            'code' => 'T',
            'sort_order' => 4,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiType::class, 1)->create([
            'name' => 'Nómina',
            'code' => 'N',
            'sort_order' => 5,
            'status' => 1,
        ]);

        //Relacion entre CFDI
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Nota de crédito de los documentos relacionados',
            'code' => '01',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Nota de débito de los documentos relacionados',
            'code' => '02',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Devolución de mercancía sobre facturas o traslados previos',
            'code' => '03',
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Sustitución de los CFDI previos',
            'code' => '04',
            'sort_order' => 4,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Traslados de mercancias facturados previamente',
            'code' => '05',
            'sort_order' => 5,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Factura generada por los traslados previos',
            'code' => '06',
            'sort_order' => 6,
            'status' => 0,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'CFDI por aplicación de anticipo',
            'code' => '07',
            'sort_order' => 7,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Factura generada por pagos en parcialidades',
            'code' => '08',
            'sort_order' => 8,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiRelation::class, 1)->create([
            'name' => 'Factura generada por pagos diferidos',
            'code' => '09',
            'sort_order' => 9,
            'status' => 1,
        ]);

        //Usos de CFDI
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Adquisición de mercancias',
            'code' => 'G01',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Devoluciones, descuentos o bonificaciones',
            'code' => 'G02',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Gastos en general',
            'code' => 'G03',
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Construcciones',
            'code' => 'I01',
            'sort_order' => 4,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Mobilario y equipo de oficina por inversiones',
            'code' => 'I02',
            'sort_order' => 5,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Equipo de transporte',
            'code' => 'I03',
            'sort_order' => 6,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Equipo de computo y accesorios',
            'code' => 'I04',
            'sort_order' => 7,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Dados, troqueles, moldes, matrices y herramental',
            'code' => 'I05',
            'sort_order' => 8,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Comunicaciones telefónicas',
            'code' => 'I06',
            'sort_order' => 9,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Comunicaciones satelitales',
            'code' => 'I07',
            'sort_order' => 10,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Otra maquinaria y equipo',
            'code' => 'I08',
            'sort_order' => 11,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Honorarios médicos, dentales y gastos hospitalarios.',
            'code' => 'D01',
            'sort_order' => 12,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Gastos médicos por incapacidad o discapacidad',
            'code' => 'D02',
            'sort_order' => 13,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Gastos funerales',
            'code' => 'D03',
            'sort_order' => 14,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Donativos',
            'code' => 'D04',
            'sort_order' => 15,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación)',
            'code' => 'D05',
            'sort_order' => 16,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Aportaciones voluntarias al SAR',
            'code' => 'D06',
            'sort_order' => 17,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Primas por seguros de gastos médicos',
            'code' => 'D07',
            'sort_order' => 18,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Gastos de transportación escolar obligatoria',
            'code' => 'D08',
            'sort_order' => 19,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones',
            'code' => 'D09',
            'sort_order' => 20,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Pagos por servicios educativos (colegiaturas)',
            'code' => 'D10',
            'sort_order' => 21,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\CfdiUse::class, 1)->create([
            'name' => 'Por definir',
            'code' => 'P01',
            'sort_order' => 22,
            'status' => 0,
        ]);

        //Monedas
        factory(\App\Models\Catalogs\Currency::class, 1)->create([
            'name' => 'Peso mexicano',
            'code' => 'MXN',
            'rate' => '1',
            'decimal_place' => '2',
            'symbol' => '$',
            'symbol_position' => 'L',
            'decimal_mark' => '.',
            'thousands_separator' => ',',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\Currency::class, 1)->create([
            'name' => 'Dolar americano',
            'code' => 'USD',
            'rate' => '20.1329',
            'decimal_place' => '2',
            'symbol' => '$',
            'symbol_position' => 'L',
            'decimal_mark' => '.',
            'thousands_separator' => ',',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\Currency::class, 1)->create([
            'name' => 'Euro',
            'code' => 'EUR',
            'rate' => '22.9424',
            'decimal_place' => '2',
            'symbol' => '€',
            'symbol_position' => 'L',
            'decimal_mark' => ',',
            'thousands_separator' => '.',
            'sort_order' => 3,
            'status' => 1,
        ]);

        //Impuestos
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'IVA 16%',
            'code' => \App\Models\Catalogs\Tax::IVA,
            'rate' => 16.0,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 1,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::TRASLADO
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'IVA 0%',
            'code' => \App\Models\Catalogs\Tax::IVA,
            'rate' => 0.0,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 2,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::TRASLADO
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'IVA Exento',
            'code' => \App\Models\Catalogs\Tax::IVA,
            'rate' => 0.0,
            'factor' => \App\Models\Catalogs\Tax::EXENTO,
            'sort_order' => 3,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::TRASLADO
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'Ret. IVA 4%',
            'code' => \App\Models\Catalogs\Tax::IVA,
            'rate' => -4.0,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 4,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::RETENCION
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'Ret. ISR 10%',
            'code' => \App\Models\Catalogs\Tax::ISR,
            'rate' => -10.0,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 5,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::RETENCION
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'Ret. IVA 10.67%',
            'code' => \App\Models\Catalogs\Tax::IVA,
            'rate' => -10.6667,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 6,
            'status' => 1,
            'type' => \App\Models\Catalogs\Tax::RETENCION
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'ISH 3%',
            'code' => null,
            'rate' => 3.0000,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 7,
            'status' => 1,
            'local_taxes' => 1,
            'type' => \App\Models\Catalogs\Tax::TRASLADO
        ]);
        factory(\App\Models\Catalogs\Tax::class, 1)->create([
            'name' => 'IVA 8%',
            'code' => null,
            'rate' => 8.0000,
            'factor' => \App\Models\Catalogs\Tax::TASA,
            'sort_order' => 8,
            'status' => 1,
            'local_taxes' => 0,
            'type' => \App\Models\Catalogs\Tax::TRASLADO
        ]);

        //Documentos
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Factura',
            'code' => 'customer.invoice',
            'prefix' => 'FAC',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::DEBIT,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','I')->get()->random()->id,
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Nota de crédito',
            'code' => 'customer.credit_note',
            'prefix' => 'NCR',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::CREDIT,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','E')->get()->random()->id,
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Recibo de Pago',
            'code' => 'customer.payment',
            'prefix' => 'PAG',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::CREDIT,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','P')->get()->random()->id,
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Recibo de arrendamiento',
            'code' => 'customer.lease',
            'prefix' => 'ARR',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::DEBIT,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','I')->get()->random()->id,
            'sort_order' => 4,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Recibo de honorarios',
            'code' => 'customer.fee',
            'prefix' => 'HON',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::DEBIT,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','I')->get()->random()->id,
            'sort_order' => 5,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Carta porte',
            'code' => 'customer.transfer',
            'prefix' => 'TRA',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::NO_NATURE,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','T')->get()->random()->id,
            'sort_order' => 6,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Cotización',
            'code' => 'customer.quotation',
            'prefix' => 'CTZ',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::NO_NATURE,
            'cfdi_type_id' => null,
            'sort_order' => 7,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Recibo de nómina',
            'code' => 'employee.payroll',
            'prefix' => 'NOM',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::NO_NATURE,
            'cfdi_type_id' => \App\Models\Catalogs\CfdiType::where('code','=','N')->get()->random()->id,
            'sort_order' => 8,
            'status' => 1,
        ]);
        factory(\App\Models\Base\DocumentType::class, 1)->create([
            'name' => 'Nota de venta',
            'code' => 'customer.remission',
            'prefix' => 'CVN',
            'current_number' => 0,
            'increment_number' => 1,
            'nature' => \App\Models\Base\DocumentType::NO_NATURE,
            'cfdi_type_id' => null,
            'sort_order' => 9,
            'status' => 1,
        ]);

        //Bancos
        $sql_bank = \Storage::path('sql/bank.sql');
        \DB::unprepared(file_get_contents($sql_bank));

        //Vendedores
        /*factory(\App\Models\Sales\Salesperson::class, 1)->create([
            'name' => 'Fidel Angel Hernández Cruz',
            'email' => 'sksistemas@hotmail.com',
            'comission_percent' => 3,
            'sort_order' => 0,
            'status' => 1,
        ]);*/

        //Terminos de pago
        factory(\App\Models\Catalogs\PaymentTerm::class, 1)->create([
            'name' => 'Contado',
            'days' => 0,
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentTerm::class, 1)->create([
            'name' => '15 Días de crédito',
            'days' => 15,
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\PaymentTerm::class, 1)->create([
            'name' => '30 Días de crédito',
            'days' => 30,
            'sort_order' => 3,
            'status' => 1,
        ]);


        //Paises, Estados y Municipios
        /*factory(\App\Models\Catalogs\Country::class, 1)->create([
            'name' => 'México',
            'code' => 'MEX',
            'sort_order' => 1,
            'status' => 1,
        ])->each(function (\App\Models\Catalogs\Country $c) {
            factory(\App\Models\Catalogs\State::class, 1)->create([ //Estado
                'name' => 'Querétaro',
                'country_id' => $c->id,
                'status' => 1
            ])->each(function (\App\Models\Catalogs\State $s) {
                factory(\App\Models\Catalogs\City::class, 1)->create([ //Municipio
                    'name' => 'Querétaro',
                    'state_id' => $s->id,
                    'status' => 1
                ]);
            });
        });*/
        $sql_country_state_city = \Storage::path('sql/country_state_city.sql');
        \DB::connection('tenant')->unprepared(file_get_contents($sql_country_state_city));

        //Empresas
        /*$path_company_images = $taxid .'/'.\App\Models\Base\Company::PATH_IMAGES;
        if(!\Storage::exists($path_company_images)) {
            \Storage::makeDirectory($path_company_images, 0777, true);
        }*/
        $country = \App\Models\Catalogs\Country::where('code','=','MEX')->get()->first();
        factory(\App\Models\Base\Company::class, 1)->create([
            'name' => 'SU EMPRESA S.A. DE C.V.',
            'image' => '',
            'taxid' => $taxid,
            'tax_regimen_id' => null,
            'email' => '',
            'phone' => '',
            'address_1' => '',
            'address_2' => '',
            'address_4' => '',
            'country_id' => $country->id,
            'postcode' => '',
            'module_payroll' => '1',
        ]);

        //Sucursal
        factory(\App\Models\Base\BranchOffice::class, 1)->create([
            'name' => 'MATRIZ',
            'email' => '',
            'phone' => '',
            'address_1' => '',
            'address_2' => '',
            'address_4' => '',
            'country_id' => $country->id,
            'postcode' => '',
        ]);

        //Actualizacion de empresa para sucursales y tipos de documentos
        $company = \App\Models\Base\Company::active()->orderBy('id')->get()->first();
        $document_types = \App\Models\Base\DocumentType::where('id','>','0')->update([
            'company_id' => $company->id
        ]);
        $branch_offices = \App\Models\Base\BranchOffice::where('id','>','0')->update([
            'company_id' => $company->id
        ]);

        //Clientes
        //factory(App\Models\Sales\Customer::class,5)->create();
        factory(\App\Models\Sales\Customer::class, 1)->create([
            'name' => 'Público en general',
            'taxid' => 'XAXX010101000',
            'email' => '',
            'phone' => '',
            'payment_term_id' => \App\Models\Catalogs\PaymentTerm::where('name','=','Contado')->get()->random()->id,
            'payment_way_id' => \App\Models\Catalogs\PaymentWay::where('code','=','01')->get()->random()->id,
            'payment_method_id' => \App\Models\Catalogs\PaymentMethod::where('code','=','PUE')->get()->random()->id,
            'cfdi_use_id' => \App\Models\Catalogs\CfdiUse::where('code','=','G01')->get()->random()->id,
            'salesperson_id' => null,
            'address_1' => '',
            'country_id' => $country->id,
            'postcode' => '',
            'company_id' => $company->id
        ]);

        //Productos
        /*$path_product_images = $taxid .'/'.\App\Models\Catalogs\Product::PATH_IMAGES;
        if(!\Storage::exists($path_product_images)) {
            \Storage::makeDirectory($path_product_images, 0777, true);
        }
        factory(App\Models\Catalogs\Product::class,10)->create([
            'image' => \Faker\Provider\Image::image(\Storage::path($path_product_images), 200, 200, 'food', false),
            'company_id' => $company->id
        ]);*/

        //Clave pedimento
        $sql_pediment = \Storage::path('sql/pediment.sql');
        \DB::unprepared(file_get_contents($sql_pediment));

        //Fraccion arancelaria
        $sql_tariff_fraction = \Storage::path('sql/tariff_fraction.sql');
        \DB::unprepared(file_get_contents($sql_tariff_fraction));

        //Incoterm
        $sql_incoterm = \Storage::path('sql/incoterm.sql');
        \DB::unprepared(file_get_contents($sql_incoterm));

        //Motivo de traslado
        $sql_transfer_reason = \Storage::path('sql/transfer_reason.sql');
        \DB::unprepared(file_get_contents($sql_transfer_reason));

        //Tipo de operacion
        $sql_operation_type = \Storage::path('sql/operation_type.sql');
        \DB::unprepared(file_get_contents($sql_operation_type));

        //Unidad de medida aduana
        $sql_uom_custom = \Storage::path('sql/uom_custom.sql');
        \DB::unprepared(file_get_contents($sql_uom_custom));

        //Codigos postales
        $sql_postcode = \Storage::path('sql/postcode.sql');
        \DB::unprepared(file_get_contents($sql_postcode));
        $sql_postcode = \Storage::path('sql/postcode2.sql');
        \DB::unprepared(file_get_contents($sql_postcode));

        //Origen de recursos
        $sql_source_resource = \Storage::path('sql/source_resource.sql');
        \DB::unprepared(file_get_contents($sql_source_resource));

        //Periodicidad del pago
        $sql_frequency_payment = \Storage::path('sql/frequency_payment.sql');
        \DB::unprepared(file_get_contents($sql_frequency_payment));

        //Tipos de contrato
        $sql_contract_type = \Storage::path('sql/contract_type.sql');
        \DB::unprepared(file_get_contents($sql_contract_type));

        //Deducciones
        $sql_deduction= \Storage::path('sql/deduction.sql');
        \DB::unprepared(file_get_contents($sql_deduction));

        //Tipos de horas extra
        $sql_overtimes_type= \Storage::path('sql/overtimes_type.sql');
        \DB::unprepared(file_get_contents($sql_overtimes_type));

        //Tipos de incapacidad
        $sql_disability_type= \Storage::path('sql/disability_type.sql');
        \DB::unprepared(file_get_contents($sql_disability_type));

        //Tipos de jornada laboral
        $sql_workday_type= \Storage::path('sql/workday_type.sql');
        \DB::unprepared(file_get_contents($sql_workday_type));

        //Tipos de nomina
        $sql_payroll_type= \Storage::path('sql/payroll_type.sql');
        \DB::unprepared(file_get_contents($sql_payroll_type));

        //Otros tipos de pago
        $sql_other_payment_type= \Storage::path('sql/other_payment_type.sql');
        \DB::unprepared(file_get_contents($sql_other_payment_type));

        //Percepciones
        $sql_perception= \Storage::path('sql/perception.sql');
        \DB::unprepared(file_get_contents($sql_perception));

        //Regimen de contratacion
        $sql_recruitment_regime= \Storage::path('sql/recruitment_regime.sql');
        \DB::unprepared(file_get_contents($sql_recruitment_regime));

        //Clases de riegos de puesto
        $sql_job_risk_classe= \Storage::path('sql/job_risk_classe.sql');
        \DB::unprepared(file_get_contents($sql_job_risk_classe));

        //Tipos de gastos
        factory(\App\Models\Catalogs\ExpenseType::class, 1)->create([
            'name' => 'Otros gastos',
            'sort_order' => 1,
            'status' => 1,
        ]);

        $tax_regime = TaxRegimen::updateOrCreate(
            ['code' => '625'],
            [
                'name' => 'Régimen de las Actividades Empresariales con ingresos a través de Plataformas Tecnológicas',
                'sort_order' => '22'
            ]
        );

        $tax_regime = TaxRegimen::updateOrCreate(
            ['code' => '626'],
            [
                'name' => 'Régimen Simplificado de Confianza',
                'sort_order' => '23'
            ]
        );

        $incoterm = \App\Models\Catalogs\Incoterm::updateOrCreate(
            ['code' => 'DPU'],
            [
                'name' => 'ENTREGADA Y DESCARGADA EN LUGAR ACORDADO.',
                'sort_order' => '16'
            ]
        );

        $other_payment_type = \App\Models\Catalogs\OtherPaymentType::updateOrCreate(
            ['code' => '009'],
            [
                'name' => 'Reembolso de descuentos efectuados para el crédito de vivienda.',
                'sort_order' => '9'
            ]
        );

        \App\Models\Catalogs\TariffFraction::where('id','>', 0)
          ->update(['status' => 0]);

        $sql_tariff_fraction = \Storage::path('sql/tariff_fraction_28122020.sql');
        \DB::unprepared(file_get_contents($sql_tariff_fraction));

        $sql_tariff_fraction = \Storage::path('sql/tariff_fraction_12122022.sql');
        \DB::unprepared(file_get_contents($sql_tariff_fraction));

        $sql_carta_porte = \Storage::path('sql/carta_porte.sql');
        \DB::unprepared(file_get_contents($sql_carta_porte));

        factory(\App\Models\Catalogs\ReasonCancellation::class, 1)->create([
            'name' => 'Comprobante emitido con errores con relación',
            'code' => '01',
            'sort_order' => 1,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\ReasonCancellation::class, 1)->create([
            'name' => 'Comprobante emitido con errores sin relación',
            'code' => '02',
            'sort_order' => 2,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\ReasonCancellation::class, 1)->create([
            'name' => 'No se llevó a cabo la operación',
            'code' => '03',
            'sort_order' => 3,
            'status' => 1,
        ]);
        factory(\App\Models\Catalogs\ReasonCancellation::class, 1)->create([
            'name' => 'Operación nominativa relacionada en la factura global',
            'code' => '04',
            'sort_order' => 4,
            'status' => 1,
        ]);

        $cfdi_use = CfdiUse::updateOrCreate(
            ['code' => 'S01'],
            [
                'name' => 'Sin efectos fiscales',
                'sort_order' => '23',
            ]
        );
        $cfdi_use = CfdiUse::updateOrCreate(
            ['code' => 'CP01'],
            [
                'name' => 'Pagos',
                'sort_order' => '24',
            ]
        );
        $cfdi_use = CfdiUse::updateOrCreate(
            ['code' => 'CN01'],
            [
                'name' => 'Nómina',
                'sort_order' => '25',
            ]
        );
    }
}
