# Factura 16 Multitenant

Factura 16 es un sistema de facturación electrónica, genera, sella y timbra tus CFDI’s bajo los requerimientos establecidos por el SAT, de una forma más simple y con el precio más bajo del mercado.

## Frameworks 
- Laravel 5.6
- Bootstrap 3.3

## Requerimientos
- PHP 7.4
- OpenSSL PHP Extension
- PDO PHP Extension
- Mbstring PHP Extension
- Tokenizer PHP Extension
- XML PHP Extension
- XSL PHP Extension
- SOAP PHP Extension
- MySQL 5.6.*
- Servidor web (Apache, Nginx, IIS)

## Instalación
1. Clonar o descargar repositorio
2. Ejecutar
   ```sh
    # chmod -R 777 storage
    # chmod -R 777 bootstrap
    ```
3. Crear base de datos en MySQL
   ```sql
    mysql> CREATE DATABASE tenancy character set utf8mb4 collate utf8mb4_general_ci;
    mysql> CREATE DATABASE tenant character set utf8mb4 collate utf8mb4_general_ci;
    mysql> CREATE USER 'tenancy'@'localhost' IDENTIFIED WITH mysql_native_password BY 'secret';
    mysql> GRANT ALL ON *.* TO 'tenancy'@'localhost' WITH GRANT OPTION;
    mysql> FLUSH PRIVILEGES;
    mysql> EXIT;
    ```
4. Ejecutar `cp .env.example .env`.
    - Configurar conexión a la BD
    - Cuenta de correo SMTP
    - Cuenta OXXO
    - Cuenta para transferencias bancarias
    - Cuenta Paypal
    - Cuenta Stripe
5. Ejecutar 
    ```sh
    # composer install
    # php artisan key:generate
    # php artisan migrate --step
    # php artisan db:seed
    # chmod -R 777 storage
    # php artisan migrate --path=database/migrations/tenant --database=tenant
    # php artisan db:seed --class=TenantSeeder --database=tenant
    # chmod -R 777 storage
    ```
6. Configurar cron
    ```sh
    # systemctl enable cron
    # crontab -e
        * * * * * php artisan schedule:run >> /dev/null 2>&1
    # service cron reload
    ```
7. Visita [http://localhost](http://localhost), datos de acceso
    - Email: sksistemas@hotmail.com
    - Password: secret

## Desarrollador
[Factura 16](http://factura16.com) es una plataforma creada, desarrollada y soportada por [Yamiss Soft](http://yamiss.com)
## Autor
Mtr. Fidel angel Hernandez Cruz
