@extends('layouts.auth')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/login.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('body_class','login')
@section('content')
    <div class="login_wrapper">
        <div class="animate form login_form">
            <section class="login_content">
                <form method="POST" action="{{ route('login') }}" aria-label="@lang('auth/login.document_title')" role="form">
                    @csrf

                    <p class="">
                        <img style="max-width: 250px;" src="{{asset('img/logo/factura-16-logo-horizontal.png')}}" alt="@lang('auth/login.document_title')">
                    </p>
                    <h5 style="margin-bottom: 10px;">@lang('general.text_app_slogan')</h5>
                    <p style="margin-bottom: 20px;">&nbsp;</p>
                    <div>
                        <input type="email" class="form-control" name="email" value="{{ old('email') }}" placeholder="@lang('auth/login.entry_email')" required autofocus>
                    </div>
                    <div>
                        <input type="password" class="form-control" name="password" placeholder="@lang('auth/login.entry_password')" required>
                    </div>
                    @if (!$errors->isEmpty())
						<div>
                            <div class="form-group{{ $errors->first() ? ' has-error' : '' }}">
                            <span class="help-block">
                                <strong><small>{!! $errors->first() !!}</small></strong>
                            </span>
                            </div>
                        </div>
                    @endif
                    <div>
                        @include('flash::message')
                    </div>
                    <div style="margin-top: 30px; margin-bottom: 20px;">
                        <button class="btn btn-default submit" type="submit">@lang('general.button_login')</button>
                        <a class="reset_pass" href="{{ route('password.request') }}">
                            @lang('auth/login.text_link_reset_password')
                        </a>
                    </div>
                    <div class="clearfix"></div>
                    <div class="separator">
                        @if(config('app.enabled_register_tenant'))
                        <!--<p class="change_link" style="margin: 0;">
                            <a href="{{ route('register') }}" class="to_register"> @lang('general.button_register') </a>
                        </p>-->
                        @endif
                        <div class="clearfix"></div>
                        <br/>
                        <div>
                            <p>@lang('general.text_app_footer')</p>
                        </div>
                    </div>

                </form>
            </section>
        </div>
    </div>
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {


        });

    </script>
@endsection
