@extends('layouts.auth')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/login.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('body_class','login')
@section('content')
    <form method="POST" action="{{ route('login') }}" aria-label="@lang('auth/login.document_title')" role="form" id="form" target="_blank" style="margin: 15px;">
        @csrf
        <input type="hidden" name="login_iframe" value="1" >
        <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
            <label class="control-label">@lang('auth/login.entry_email')</label> <span class="required text-danger">*</span>
            <input type="email" class="form-control" name="email" value="{{ old('email') }}" placeholder="@lang('auth/login.entry_email')" required autofocus>
        </div>
        <div class="form-group form-group-sm{{ $errors->has('password') ? ' has-error' : '' }}" style="margin-top: 25px;">
            <label class="control-label">@lang('auth/login.entry_password')</label> <span class="required text-danger">*</span>
            <input type="password" class="form-control" name="password" placeholder="@lang('auth/login.entry_password')" required>
        </div>
        @if (!$errors->isEmpty())
            <div>
                <div class="form-group{{ $errors->first() ? ' has-error' : '' }}">
                <span class="help-block">
                    <strong><small>{!! $errors->first() !!}</small></strong>
                </span>
                </div>
            </div>
        @endif
        <div style="margin-top: 25px;" class="row">
            <div class="col-md-6 col-xs-6">
                <button class="btn btn-default submit" type="button" onclick="$('#form').submit(); clearInput();">@lang('general.button_login')</button>
            </div>
            <div class="col-md-6 col-xs-6 text-right">
                <a class="reset_pass" href="{{ route('password.request') }}" target="_blank">
                    @lang('auth/login.text_link_reset_password')
                </a>
            </div>
        </div>

    </form>
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">
        function clearInput() {
            $("#form input[name='email']").val("");
            $("#form input[name='password']").val("");
        }
        $(function () {

        });

    </script>
@endsection
