@extends('layouts.auth')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/login.text_reset_password'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('body_class','login')
@section('content')
    <div class="login_wrapper">
        <div class="animate form login_form">
            <section class="login_content">
                <form method="POST" action="{{ route('password.request') }}" aria-label="@lang('auth/login.text_email_password')" role="form">
                    @csrf
                    <input type="hidden" name="token" value="{{ $token }}">

                    <p class=""><img style="max-width: 250px;" src="{{asset('img/logo/factura-16-logo-horizontal.png')}}" alt="@lang('auth/login.document_title')"></p>
                    <h5>@lang('auth/login.text_reset_password')</h5>
                    <p style="margin-bottom: 15px;">&nbsp;</p>
                    <div>
                        <input type="email" class="form-control" name="email" value="{{ $email ?? old('email') }}" placeholder="@lang('auth/login.entry_email')" required autofocus>
                    </div>
                    <div>
                        <input type="password" class="form-control" name="password" placeholder="@lang('auth/login.entry_password')" required>
                    </div>
                    <div>
                        <input type="password" class="form-control" name="password_confirmation" placeholder="@lang('auth/login.entry_password_confirm')" required>
                    </div>
                    @if (!$errors->isEmpty())
                        <div>
                            <div class="form-group{{ $errors->first() ? ' has-error' : '' }}">
                            <span class="help-block">
                                <strong><small>{!! $errors->first() !!}</small></strong>
                            </span>
                            </div>
                        </div>
                    @endif
                    <div style="margin-top: 35px; margin-bottom: 20px;">
                        <button class="btn btn-default submit" type="submit">@lang('general.button_save')</button>
                    </div>
                    <div class="clearfix"></div>
                    <div class="separator">
                        <p class="change_link">@lang('auth/login.text_registered')
                            <a href="{{ route('login') }}" class="to_register"> @lang('general.button_login') </a>
                        </p>
                        <div class="clearfix"></div>
                        <br/>
                        <div>
                            <p>@lang('general.text_app_footer')</p>
                        </div>
                    </div>
                </form>
            </section>
        </div>
    </div>
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {


        });

    </script>
@endsection

