@extends('layouts.auth')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/register.document_title'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('body_class','login')
@section('content')
<div class="login_wrapper" style="max-width: 490px;">
    <div class="animate form login_form">
        <section class="login_content">
            <div id="ym_loading" class="text-center hidden">
                <div class="mt-5 mb-5"><img src="/img/loading.gif" style="width: 200px;"></div>
                <h2>{{__('system/sys_customer.text_loading_register')}}</h2>
            </div>
            <form method="POST" action="{{ route('register') }}" aria-label="@lang('auth/register.document_title')" role="form" id="form">
                @csrf
                <input type="hidden" name="iddi" value="{{ old('iddi', $iddi) }}" >

                <p class="">
                    <img style="max-width: 250px;" src="{{asset('img/logo/factura-16-logo-horizontal.png')}}" alt="@lang('auth/login.document_title')">
                </p>
                <h5>@lang('auth/login.text_register')</h5>
                <p style="margin-bottom: 15px;">&nbsp;</p>
                <div>
                    <input type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') }}" placeholder="@lang('system/sys_customer.entry_name')" required autofocus maxlength="200">
                    @if ($errors->has('name'))
                        <div class="form-group has-error" style="margin-top: -15px;">
                        <span class="help-block">
                            <strong><small>{{ $errors->first('name') }}</small></strong>
                        </span>
                        </div>
                    @endif
                </div>
                <div>
                    <input type="text" class="form-control{{ $errors->has('taxid') ? ' is-invalid' : '' }}" name="taxid" value="{{ old('taxid') }}" placeholder="@lang('system/sys_customer.entry_taxid')" required maxlength="13" style="text-transform:uppercase;">
                    @if ($errors->has('taxid'))
                    <div class="form-group has-error" style="margin-top: -15px;">
                        <span class="help-block">
                            <strong><small>{{ $errors->first('taxid') }}</small></strong>
                        </span>
                    </div>
                    @endif
                </div>
                <div>
                    <input type="text" class="form-control{{ $errors->has('phone') ? ' is-invalid' : '' }}" name="phone" value="{{ old('phone') }}" placeholder="@lang('system/sys_customer.entry_phone')" required maxlength="10">
                    @if ($errors->has('phone'))
                    <div class="form-group has-error" style="margin-top: -15px;">
                        <span class="help-block">
                            <strong><small>{{ $errors->first('phone') }}</small></strong>
                        </span>
                    </div>
                    @endif
                </div>
                <div>
                    <input type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" placeholder="@lang('auth/login.entry_email')" required maxlength="100">
                    @if ($errors->has('email'))
                    <div class="form-group has-error" style="margin-top: -15px;">
                        <span class="help-block">
                            <strong><small>{{ $errors->first('email') }}</small></strong>
                        </span>
                    </div>
                    @endif
                </div>
                <div>
                    <input type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" placeholder="@lang('auth/login.entry_password')" required>
                    @if ($errors->has('password'))
                    <div class="form-group has-error" style="margin-top: -15px;">
                        <span class="help-block">
                            <strong><small>{{ $errors->first('password') }}</small></strong>
                        </span>
                    </div>
                    @endif
                </div>
                <div>
                    <input type="password" class="form-control" name="password_confirmation" placeholder="@lang('auth/login.entry_password_confirm')" required>
                </div>
                <div style="margin-top: 30px; margin-bottom: 20px;">
                    <button class="btn btn-default submit" type="submit">@lang('general.button_register')</button>
                </div>
                <div class="clearfix"></div>
                <div class="separator">
                    <p class="change_link">@lang('auth/login.text_registered')
                        <a href="{{ route('login') }}" class="to_register"> @lang('general.button_login') </a>
                    </p>
                    <div class="clearfix"></div>
                    <div>
                        <p style="margin:0;">@lang('general.text_app_footer')</p>
                    </div>
                </div>
            </form>
        </section>
    </div>
</div>
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $(document).on("submit", '#form', function (e) {
                e.preventDefault();
                var form = $(this);
                form.find(".error-login").remove();
                form.addClass('hidden')
                $("#ym_loading").removeClass('hidden')
                window.scrollTo(0, 0);

                Pace.ignore(function(){
                    $.ajax({
                        url: form.attr('action'),
                        type: "POST",
                        dataType: "JSON",
                        data: form.serialize(),
                        success: function (data) {
                            if (data.success) {
                                setTimeout(function () {
                                    location.href = "{{ route('login') }}";
                                }, 2000);
                            }
                        },
                        error: function (error, textStatus, errorThrown) {
                            form.removeClass('hidden')
                            $("#ym_loading").addClass('hidden')
                            if (error.status == 422) {
                                let message = error.responseJSON.error;
                                //Si trae objecto con errores
                                if(typeof(message) === "object"){
                                    $.each( message, function( key, value ) {
                                        form.find("[name='"+key+"']").after(messageSmallHelpBlock2(value));
                                    });
                                }else{
                                    $("#general_messages").html(alertMessage("danger", message));
                                }
                                setTimeout(function () {
                                    $("#general_messages").html("");
                                }, 12000);
                            } else if (error.status == 403 || error.status == 401) {
                                location.href = "{{ route('login') }}";
                            } else {
                                alert(errorThrown + "\r\n" + error.statusText + "\r\n" + error.responseText);
                            }
                        }
                    })
                })
            });

        });

    </script>
@endsection
