@extends('layouts.app')
@section('meta')

@endsection
@section('title',config('app.name') . ' | ' . __('auth/user.document_title_edit_profile'))
@section('css_specific')

@endsection
@section('css')

@endsection
@section('content')
    <div id="modals">

    </div>

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">

            <!-- Titulo -->
            <div class="page-title">
                <div class="title_left">
                    <h3>@lang('auth/user.document_title_edit_profile')</h3>
                </div>
                <div class="title_right text-right">
                    <div class="row">
                        <div class="col-md-5 col-xs-12 pull-right">
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Titulo -->

            <div class="clearfix"></div>

            <!-- Mensajes -->
            <div id="general_messages">
                @include('flash::message')
            </div>
            <!-- /Mensajes -->

            <!-- Contenido -->
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>{{ $user->name }}</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {!! Form::model($user,['route' => ['users/update-profile',$user->id],'method' => 'PUT','class' => 'form-horizontal','role' => 'form','id' => 'form', 'files' => true]) !!}
                            <div class="col-md-3 col-xs-12 profile_left">
                                <div class="profile_img">
                                    <div id="crop_avatar">
                                        <!-- Current avatar -->
                                        <img class="img-responsive avatar-view"
                                             src="{{!empty(Auth::user()->avatar) ? Auth::user()->pathAvatar() : asset('img/logged-user.jpg')}}"
                                             data-placeholder="{{asset('img/logged-user.jpg')}}"
                                             alt="@lang('auth/user.entry_avatar')"
                                             title="@lang('auth/user.text_change_avatar')" id="img_avatar">
                                    </div>
                                </div>
                                <div class="" style="margin-top: 10px;">
                                    <a href="#" class="btn btn-sm btn-info" id="btn_edit_avatar" title="Editar"><i
                                                class="fa fa-pencil"></i></a>
                                    <a href="#" class="btn btn-sm btn-danger" id="btn_delete_avatar" title="Eliminar"><i
                                                class="fa fa-trash-o"></i></a>
                                </div>
                                <h3>&nbsp;</h3>
                            </div>
                            <div class="col-md-9 col-xs-12">
                                <div class="" role="tabpanel" data-example-id="togglable-tabs">
                                    <ul id="myTab" class="nav nav-tabs bar_tabs" role="tablist">
                                        <li role="presentation" class="active"><a href="#tab_edit" id="edit-tab"
                                                                                  role="tab" data-toggle="tab"
                                                                                  aria-expanded="true">Editar</a></li>
                                    </ul>
                                    <div id="myTabContent" class="tab-content">
                                        <div role="tabpanel" class="tab-pane fade active in" id="tab_edit"
                                             aria-labelledby="edit-tab">
                                        <!-- input hidden -->
                                        {!! Form::hidden('avatar', old('avatar')) !!}
                                        <!-- /.input hidden -->
                                            <div class="row">
                                                <div class="form-group form-group-sm{{ $errors->has('name') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('name', __('auth/user.entry_name') . ' <span class="required">*</span>', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_name'),'required','autofocus']) !!}
                                                        @if ($errors->has('name'))
                                                            <span class="help-block"><small>{{ $errors->first('name') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('email') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('email', __('auth/user.entry_email') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::email('email', old('email'), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_email'),'required','readonly']) !!}
                                                        @if ($errors->has('email'))
                                                            <span class="help-block"><small>{{ $errors->first('email') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('password') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('password', __('auth/user.entry_password') . ' ', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::password('password', ['class' => 'form-control', 'placeholder' => __('auth/user.entry_password')]) !!}
                                                        @if ($errors->has('password'))
                                                            <span class="help-block"><small>{{ $errors->first('password') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                                    {!! html_entity_decode(Form::label('password_confirmation', __('auth/user.entry_password_confirmation') . ' ', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::password('password_confirmation', ['class' => 'form-control', 'placeholder' => __('auth/user.entry_password_confirmation')]) !!}
                                                        @if ($errors->has('password_confirmation'))
                                                            <span class="help-block"><small>{{ $errors->first('password_confirmation') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('expiry_date') ? ' has-error' : '' }} hidden">
                                                    {!! html_entity_decode(Form::label('expiry_date', __('auth/user.entry_expiry_date') . '', ['class' => 'col-md-3 col-xs-12 control-label'])) !!}
                                                    <div class="col-md-6 col-xs-12">
                                                        {!! Form::email('expiry_date', old('expiry_date',$user->expiry_date ? \App\Helpers\Helper::convertSqlToDateTime($user->expiry_date) : ''), ['class' => 'form-control', 'placeholder' => __('auth/user.entry_expiry_date'),'readonly']) !!}
                                                        @if ($errors->has('expiry_date'))
                                                            <span class="help-block"><small>{{ $errors->first('expiry_date') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="form-group form-group-sm{{ $errors->has('file_avatar') ? ' has-error' : '' }}">
                                                    <div class="col-md-6 col-xs-12 col-md-offset-3">
                                                        {!! Form::file('file_avatar', ['class'=> 'hidden']) !!}
                                                        @if ($errors->has('file_avatar'))
                                                            <span class="help-block"><small>{{ $errors->first('file_avatar') }}</small></span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="ln_solid"></div>
                                                <div class="">
                                                    <div class="col-md-6 col-xs-12 col-md-offset-3 footer-form">
                                                        {!! Form::button(__('general.button_save'),['type' => 'submit', 'class' => 'btn btn-sm btn-primary']) !!}
                                                        &nbsp;&nbsp;&nbsp;
                                                        <a href="{{route('users.index',request()->except('page'))}}"
                                                           class="btn btn-sm btn-default">@lang('general.button_discard')
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div><!-- /x_content -->
                    </div><!-- /x_panel -->
                </div>
            </div><!-- /Contenido -->

        </div>
    </div><!-- /page content -->
@endsection
@section('scripts_specific')

@endsection
@section('scripts')
    <script type="text/javascript">

        $(function () {
            $("#form #btn_edit_avatar").on("click", function (e) {
                e.preventDefault();
                $("#form input[name='file_avatar']").trigger('click');
            });
            $("#form #btn_delete_avatar").on("click", function (e) {
                e.preventDefault();
                $("#form #img_avatar").attr('src', $("#form #img_avatar").attr('data-placeholder'));
                $("#form input[name='avatar']").val('');
            });
            $("#form input[name='file_avatar']").on("change", function () { //Precarga imagen para visualizar
                if ($(this)[0].files && $(this)[0].files[0]) {
                    let reader = new FileReader();
                    reader.onload = function (e) {
                        $("#form #img_avatar").attr("src", e.target.result);
                    };
                    reader.readAsDataURL($(this)[0].files[0]);
                }
            });
        });

    </script>
@endsection
